/*
 * Decompiled with CFR 0.152.
 */
package eu.gnome.morena.ui;

import eu.gnome.morena.Scanner;
import eu.gnome.morena.wia.SupportedPropertyValues;
import eu.gnome.morena.wia.WIAScanner;
import java.awt.Color;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.GridLayout;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Vector;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.BorderFactory;
import javax.swing.InputVerifier;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JSlider;
import javax.swing.JTextField;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.text.JTextComponent;

public class ScannerOptionPane
extends JPanel {
    private static final long serialVersionUID = -4839795326051637411L;
    private static final String FU_FLATBED = "flatbed";
    private static final String FU_FEEDER = "feeder";
    private static final String FU_DEFAULT = "default";
    private Window parent;
    private Scanner scanner;
    private WIAScanner wiaScanner;
    private boolean saved;
    private Map<Integer, Mode> modesMap;
    private JComboBox funitComp;
    private JCheckBox duplexComp;
    private JComboBox modesComp;
    private JComboBox resolComp;
    private JSlider brightnessComp;
    private JTextField brightnessField;
    private SliderListenerAndVerifier brightnessVerifier;
    private JSlider contrastComp;
    private JTextField contrastField;
    private SliderListenerAndVerifier contrastVerifier;
    private JButton okButton;
    private JButton cancelButton;
    protected GridBagLayout layout;
    protected GridBagConstraints constraints = new GridBagConstraints();
    private Action okAction = new AbstractAction("OK"){

        public void actionPerformed(ActionEvent actionEvent) {
            if (!(ScannerOptionPane.this.wiaScanner == null || ScannerOptionPane.this.brightnessVerifier.isCorrect && ScannerOptionPane.this.contrastVerifier.isCorrect)) {
                if (ScannerOptionPane.this.brightnessVerifier.isCorrect) {
                    ScannerOptionPane.this.contrastField.setBackground(Color.PINK);
                } else {
                    ScannerOptionPane.this.brightnessField.setBackground(Color.PINK);
                }
            } else {
                ScannerOptionPane.this.save();
                ScannerOptionPane.this.parent.setVisible(false);
            }
        }
    };
    private Action cancelAction = new AbstractAction("Cancel"){

        public void actionPerformed(ActionEvent actionEvent) {
            ScannerOptionPane.this.parent.setVisible(false);
        }
    };

    public ScannerOptionPane(Window window) {
        this.parent = window;
        this.wiaScanner = null;
        this.modesMap = new HashMap<Integer, Mode>();
        Mode mode = new Mode(-1, "Black & White (1 bit)");
        this.modesMap.put(-1, mode);
        mode = new Mode(1, "Black & White (1 bit)");
        this.modesMap.put(1, mode);
        mode = new Mode(-8, "Grayscale (8 bit)");
        this.modesMap.put(-8, mode);
        mode = new Mode(-16, "Grayscale (16 bit)");
        this.modesMap.put(-16, mode);
        mode = new Mode(8, "Color (8 bit)");
        this.modesMap.put(8, mode);
        mode = new Mode(16, "Color (16 bit)");
        this.modesMap.put(16, mode);
        this.layout = new GridBagLayout();
        this.setLayout(this.layout);
        this.layout.setConstraints(this, this.constraints);
        this.setBorder(BorderFactory.createEmptyBorder(10, 20, 10, 20));
        this.constraints.insets = new Insets(2, 4, 2, 4);
        this.saved = false;
    }

    public void load(Scanner scanner) {
        Object object;
        this.scanner = scanner;
        if (scanner instanceof WIAScanner) {
            this.wiaScanner = (WIAScanner)scanner;
        }
        Vector<String> vector = new Vector<String>();
        if (scanner.getFlatbedFunctionalUnit() >= 0) {
            vector.add(FU_FLATBED);
        }
        if (scanner.getFeederFunctionalUnit() >= 0) {
            vector.add(FU_FEEDER);
        }
        if (vector.isEmpty()) {
            vector.add(FU_DEFAULT);
        }
        this.funitComp = new JComboBox(vector);
        this.duplexComp = new JCheckBox("Duplex");
        this.duplexComp.setSelected(scanner.isDuplexEnabled());
        List<Integer> list = scanner.getSupportedModes();
        int n = scanner.getMode();
        Mode mode = this.modesMap.get(n);
        Vector<Mode> vector2 = new Vector<Mode>();
        for (Integer serializable2 : list) {
            object = this.modesMap.get(serializable2);
            if (object == null) continue;
            vector2.add((Mode)object);
        }
        this.modesComp = new JComboBox(vector2);
        if (vector2.contains(mode)) {
            this.modesComp.setSelectedItem(mode);
        }
        List<Integer> list2 = scanner.getSupportedResolutions();
        this.resolComp = new JComboBox<Integer>(list2.toArray(new Integer[list2.size()]));
        this.resolComp.setEditable(true);
        this.resolComp.setSelectedItem(scanner.getResolution());
        this.okButton = new JButton(this.okAction);
        this.cancelButton = new JButton(this.cancelAction);
        JPanel jPanel = new JPanel();
        jPanel.setBorder(BorderFactory.createEmptyBorder(20, 1, 10, 1));
        object = new GridLayout(1, 2);
        ((GridLayout)object).setHgap(3);
        jPanel.setLayout((LayoutManager)object);
        jPanel.add(this.okButton);
        jPanel.add(this.cancelButton);
        int n2 = 0;
        this.add(null, new JLabel("Source"), 0, n2, 1, 1, 0, 17, 1, 1, true);
        this.add("fu", this.funitComp, 1, n2, 1, 1, 0, 17, 100, 1, true);
        this.add("duplex", this.duplexComp, 2, n2++, 1, 1, 0, 17, 100, 1, scanner.isDuplexSupported());
        this.add(null, new JLabel(" "), 0, n2++, 3, 1, 1, 10, 1, 1, true);
        this.add(null, new JLabel("Mode"), 0, n2, 1, 1, 0, 17, 1, 1, true);
        this.add("mode", this.modesComp, 1, n2++, 2, 1, 0, 17, 100, 1, true);
        this.add(null, new JLabel("Resolution"), 0, n2, 1, 1, 0, 17, 1, 1, true);
        this.add("resolution", this.resolComp, 1, n2++, 2, 1, 0, 17, 100, 1, true);
        if (this.wiaScanner != null) {
            int n3;
            this.add(null, new JLabel(" "), 0, n2++, 3, 1, 1, 10, 1, 1, true);
            SupportedPropertyValues supportedPropertyValues = this.wiaScanner.getPropertyValues(6154);
            if (supportedPropertyValues != null && supportedPropertyValues.isRange()) {
                n3 = supportedPropertyValues.getMaxValue() - supportedPropertyValues.getMinValue();
                this.brightnessComp = new JSlider(0, supportedPropertyValues.getMinValue(), supportedPropertyValues.getMaxValue(), this.wiaScanner.getBrightness());
                this.brightnessField = new JTextField(4);
                this.brightnessField.setText(String.valueOf(this.brightnessComp.getValue()));
                this.brightnessVerifier = new SliderListenerAndVerifier(this.brightnessComp, this.brightnessField);
                this.brightnessField.setInputVerifier(this.brightnessVerifier);
                this.brightnessComp.addChangeListener(this.brightnessVerifier);
                this.brightnessComp.setMajorTickSpacing(n3 / 2);
                this.brightnessComp.setPaintTicks(true);
                this.brightnessComp.setPaintLabels(true);
                this.add(null, new JLabel("Brightness", 4), 0, n2++, 3, 1, 0, 17, 1, 1, true);
                this.add(null, this.brightnessComp, 0, n2, 3, 1, 1, 17, 100, 1, true);
                this.add("brightness", this.brightnessField, 3, n2++, 1, 1, 0, 11, 1, 1, true);
            }
            if ((supportedPropertyValues = this.wiaScanner.getPropertyValues(6155)) != null && supportedPropertyValues.isRange()) {
                n3 = supportedPropertyValues.getMaxValue() - supportedPropertyValues.getMinValue();
                this.contrastComp = new JSlider(0, supportedPropertyValues.getMinValue(), supportedPropertyValues.getMaxValue(), this.wiaScanner.getContrast());
                this.contrastField = new JTextField(4);
                this.contrastField.setText(String.valueOf(this.contrastComp.getValue()));
                this.contrastVerifier = new SliderListenerAndVerifier(this.contrastComp, this.contrastField);
                this.contrastField.setInputVerifier(this.contrastVerifier);
                this.contrastComp.addChangeListener(this.contrastVerifier);
                this.contrastComp.setMajorTickSpacing(n3 / 2);
                this.contrastComp.setPaintTicks(true);
                this.contrastComp.setPaintLabels(true);
                this.add(null, new JLabel("Contrast", 4), 0, n2++, 3, 1, 0, 17, 1, 1, true);
                this.add(null, this.contrastComp, 0, n2, 3, 1, 1, 17, 100, 1, true);
                this.add("contrast", this.contrastField, 3, n2++, 1, 1, 0, 10, 1, 1, true);
            }
        }
        this.add(null, jPanel, 0, n2++, 4, 1, 0, 10, 1, 1, true);
    }

    public void save() {
        String string = (String)this.funitComp.getSelectedItem();
        if (string.equals(FU_FLATBED)) {
            this.scanner.setFunctionalUnit(this.scanner.getFlatbedFunctionalUnit());
        } else if (string.equals(FU_FEEDER)) {
            this.scanner.setFunctionalUnit(this.scanner.getFeederFunctionalUnit());
            this.scanner.setDuplexEnabled(this.duplexComp.isSelected());
        } else {
            this.scanner.setFunctionalUnit(0);
        }
        if (this.modesComp.getItemCount() > 0) {
            this.scanner.setMode(((Mode)this.modesComp.getSelectedItem()).value);
        }
        if (this.resolComp.getItemCount() > 0) {
            this.scanner.setResolution((Integer)this.resolComp.getSelectedItem());
        }
        if (this.wiaScanner != null) {
            this.wiaScanner.setBrightness(Integer.parseInt(this.brightnessField.getText()));
            this.wiaScanner.setContrast(Integer.parseInt(this.contrastField.getText()));
        }
        this.saved = true;
    }

    private Component add(String string, Component component, int n, int n2, int n3, int n4, int n5, int n6, int n7, int n8, boolean bl) {
        component.setName(string);
        this.constraints.gridx = n;
        this.constraints.gridy = n2;
        this.constraints.gridwidth = n3;
        this.constraints.gridheight = n4;
        this.constraints.fill = n5;
        this.constraints.anchor = n6;
        this.constraints.weightx = n7;
        this.constraints.weighty = n8;
        this.add(component, this.constraints);
        if (!bl) {
            component.setEnabled(false);
        }
        super.invalidate();
        return component;
    }

    public boolean isSaved() {
        return this.saved;
    }

    class SliderListenerAndVerifier
    extends InputVerifier
    implements ChangeListener {
        private JSlider sliderComp;
        private JTextComponent showComp;
        private boolean isCorrect;

        public SliderListenerAndVerifier(JSlider jSlider, JTextComponent jTextComponent) {
            this.sliderComp = jSlider;
            this.showComp = jTextComponent;
            this.isCorrect = true;
        }

        public void stateChanged(ChangeEvent changeEvent) {
            JSlider jSlider = (JSlider)changeEvent.getSource();
            this.showComp.setText(String.valueOf(jSlider.getValue()));
            this.showComp.setBackground(Color.WHITE);
        }

        public boolean verify(JComponent jComponent) {
            int n = 0;
            try {
                n = Integer.parseInt(((JTextComponent)jComponent).getText());
            }
            catch (NumberFormatException numberFormatException) {
                return false;
            }
            boolean bl = this.isCorrect = this.sliderComp.getMinimum() <= n && n <= this.sliderComp.getMaximum();
            if (this.isCorrect) {
                this.showComp.setBackground(Color.WHITE);
            } else {
                this.showComp.setBackground(Color.PINK);
            }
            return this.isCorrect;
        }
    }

    class Mode {
        private String desc;
        private int value;

        public Mode(int n, String string) {
            this.value = n;
            this.desc = string;
        }

        public int hashCode() {
            int n = 1;
            n = 31 * n + this.getOuterType().hashCode();
            n = 31 * n + this.value;
            return n;
        }

        public boolean equals(Object object) {
            if (this == object) {
                return true;
            }
            if (object == null) {
                return false;
            }
            if (this.getClass() != object.getClass()) {
                return false;
            }
            Mode mode = (Mode)object;
            if (!this.getOuterType().equals(mode.getOuterType())) {
                return false;
            }
            return this.value == mode.value;
        }

        public String toString() {
            return this.desc;
        }

        private ScannerOptionPane getOuterType() {
            return ScannerOptionPane.this;
        }
    }
}

