/*
 * Decompiled with CFR 0.152.
 */
package org.mustangproject.ZUGFeRD;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.util.Map;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import org.apache.pdfbox.pdmodel.PDDocument;
import org.apache.pdfbox.pdmodel.PDDocumentNameDictionary;
import org.apache.pdfbox.pdmodel.PDEmbeddedFilesNameTreeNode;
import org.apache.pdfbox.pdmodel.common.filespecification.PDComplexFileSpecification;
import org.apache.pdfbox.pdmodel.common.filespecification.PDEmbeddedFile;
import org.w3c.dom.Document;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.SAXException;

public class ZUGFeRDImporter {
    private boolean containsMeta = false;
    private String foreignReference;
    private String BIC;
    private String IBAN;
    private String holder;
    private String amount;
    private String meta;
    private String bankName;
    private boolean amountFound;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void extract(String pdfFilename) {
        PDDocument doc = null;
        try {
            doc = PDDocument.load((String)pdfFilename);
            PDDocumentNameDictionary names = new PDDocumentNameDictionary(doc.getDocumentCatalog());
            PDEmbeddedFilesNameTreeNode etn = names.getEmbeddedFiles();
            if (etn == null) {
                doc.close();
                return;
            }
            Map efMap = etn.getNames();
            for (String filename : efMap.keySet()) {
                if (!filename.equals("ZUGFeRD-invoice.xml")) continue;
                this.containsMeta = true;
                PDComplexFileSpecification fileSpec = (PDComplexFileSpecification)efMap.get(filename);
                PDEmbeddedFile embeddedFile = fileSpec.getEmbeddedFile();
                this.setMeta(new String(embeddedFile.getByteArray()));
            }
        }
        catch (IOException e1) {
            e1.printStackTrace();
        }
        finally {
            try {
                if (doc != null) {
                    doc.close();
                }
            }
            catch (IOException iOException) {}
        }
    }

    public void parse() {
        Node detail;
        int detailIndex;
        NodeList bookingDetails;
        Node booking;
        int bookingIndex;
        DocumentBuilderFactory factory = null;
        DocumentBuilder builder = null;
        Document document = null;
        factory = DocumentBuilderFactory.newInstance();
        factory.setNamespaceAware(true);
        try {
            builder = factory.newDocumentBuilder();
        }
        catch (ParserConfigurationException ex3) {
            ex3.printStackTrace();
        }
        try {
            ByteArrayInputStream bais = new ByteArrayInputStream(this.meta.getBytes());
            document = builder.parse(bais);
        }
        catch (SAXException ex1) {
            ex1.printStackTrace();
        }
        catch (IOException ex2) {
            ex2.printStackTrace();
        }
        NodeList ndList = document.getDocumentElement().getElementsByTagNameNS("*", "PaymentReference");
        for (bookingIndex = 0; bookingIndex < ndList.getLength(); ++bookingIndex) {
            booking = ndList.item(bookingIndex);
            this.setForeignReference(booking.getTextContent());
        }
        ndList = document.getElementsByTagNameNS("*", "PayeePartyCreditorFinancialAccount");
        for (bookingIndex = 0; bookingIndex < ndList.getLength(); ++bookingIndex) {
            booking = ndList.item(bookingIndex);
            bookingDetails = booking.getChildNodes();
            for (detailIndex = 0; detailIndex < bookingDetails.getLength(); ++detailIndex) {
                detail = bookingDetails.item(detailIndex);
                if (detail.getLocalName() == null || !detail.getLocalName().equals("IBANID")) continue;
                this.setIBAN(detail.getTextContent());
            }
        }
        ndList = document.getElementsByTagNameNS("*", "PayeeSpecifiedCreditorFinancialInstitution");
        for (bookingIndex = 0; bookingIndex < ndList.getLength(); ++bookingIndex) {
            booking = ndList.item(bookingIndex);
            bookingDetails = booking.getChildNodes();
            for (detailIndex = 0; detailIndex < bookingDetails.getLength(); ++detailIndex) {
                detail = bookingDetails.item(detailIndex);
                if (detail.getLocalName() != null && detail.getLocalName().equals("BICID")) {
                    this.setBIC(detail.getTextContent());
                }
                if (detail.getLocalName() == null || !detail.getLocalName().equals("Name")) continue;
                this.setBankName(detail.getTextContent());
            }
        }
        ndList = document.getElementsByTagNameNS("*", "SellerTradeParty");
        for (bookingIndex = 0; bookingIndex < ndList.getLength(); ++bookingIndex) {
            booking = ndList.item(bookingIndex);
            bookingDetails = booking.getChildNodes();
            for (detailIndex = 0; detailIndex < bookingDetails.getLength(); ++detailIndex) {
                detail = bookingDetails.item(detailIndex);
                if (detail.getLocalName() == null || !detail.getLocalName().equals("Name")) continue;
                this.setHolder(detail.getTextContent());
            }
        }
        ndList = document.getElementsByTagNameNS("*", "DuePayableAmount");
        for (bookingIndex = 0; bookingIndex < ndList.getLength(); ++bookingIndex) {
            booking = ndList.item(bookingIndex);
            this.amountFound = true;
            this.setAmount(booking.getTextContent());
        }
        if (!this.amountFound) {
            ndList = document.getElementsByTagNameNS("*", "GrandTotalAmount");
            for (bookingIndex = 0; bookingIndex < ndList.getLength(); ++bookingIndex) {
                booking = ndList.item(bookingIndex);
                this.amountFound = true;
                this.setAmount(booking.getTextContent());
            }
        }
    }

    public boolean containsMeta() {
        return this.containsMeta;
    }

    public String getForeignReference() {
        return this.foreignReference;
    }

    public void setForeignReference(String foreignReference) {
        this.foreignReference = foreignReference;
    }

    public String getBIC() {
        return this.BIC;
    }

    private void setBIC(String bic) {
        this.BIC = bic;
    }

    private void setBankName(String bankname) {
        this.bankName = bankname;
    }

    public String getIBAN() {
        return this.IBAN;
    }

    public String getBankName() {
        return this.bankName;
    }

    public void setIBAN(String IBAN) {
        this.IBAN = IBAN;
    }

    public String getHolder() {
        return this.holder;
    }

    private void setHolder(String holder) {
        this.holder = holder;
    }

    public String getAmount() {
        return this.amount;
    }

    private void setAmount(String amount) {
        this.amount = amount;
    }

    public void setMeta(String meta) {
        this.meta = meta;
    }

    public String getMeta() {
        return this.meta;
    }

    public boolean canParse() {
        return this.meta != null && this.meta.length() > 0 && this.meta.contains("SpecifiedExchangedDocumentContext");
    }
}

