/*
 * Decompiled with CFR 0.152.
 */
package eu.gnome.morena.ica;

import eu.gnome.morena.MorenaException;
import eu.gnome.morena.Scanner;
import eu.gnome.morena.TransferDoneListener;
import eu.gnome.morena.TransferListener;
import eu.gnome.morena.ica.ICADevice;
import java.util.ArrayList;
import java.util.List;
import java.util.Timer;
import java.util.TimerTask;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ICAScanner
extends ICADevice
implements Scanner {
    private int initialized = 0;
    private int bitDepth = 0;
    private ArrayList<Integer> supportedBitDepths;
    private int resolution = 0;
    private ArrayList<Integer> supportedResolutions;
    private int x = -1;
    private int y = -1;
    private int width = -1;
    private int height = -1;
    private int duplexSupported = 0;
    private int duplexEnabled = 0;
    private int flatbedFU = -1;
    private int feederFU = -1;

    private native void _initialize(long var1);

    private native void _transfer(long var1, int var3) throws MorenaException;

    private native double _getProgress(long var1);

    private native void _cancelTransfer(long var1);

    ICAScanner(String string, long l) {
        super(string, l);
        this._initialize(l);
    }

    @Override
    public void startTransfer(TransferDoneListener transferDoneListener, int n) throws Exception {
        super.startTransfer(transferDoneListener, n);
        try {
            this._transfer(this.handle, n);
        }
        catch (MorenaException morenaException) {
            transferDoneListener.transferFailed(morenaException.getErrorCode(), morenaException.getMessage());
        }
        catch (Throwable throwable) {
            transferDoneListener.transferFailed(-1, throwable.toString());
        }
        if (transferDoneListener instanceof TransferListener) {
            if (this.timer == null) {
                this.timer = new Timer(true);
            }
            if (this.reporter != null) {
                this.reporter.cancel();
            }
            this.reporter = new ProgressReporter();
            this.timer.scheduleAtFixedRate(this.reporter, 100L, 100L);
        }
    }

    @Override
    public void setMode(int n) {
        this.bitDepth = n;
    }

    @Override
    public int getMode() {
        return this.bitDepth;
    }

    private void addBitDepth(int n) {
        if (this.supportedBitDepths == null) {
            this.supportedBitDepths = new ArrayList();
        }
        this.supportedBitDepths.add(n);
        if (n > 1) {
            this.supportedBitDepths.add(-n);
        }
    }

    @Override
    public List<Integer> getSupportedModes() {
        return this.supportedBitDepths;
    }

    @Override
    public void setResolution(int n) {
        this.resolution = n;
    }

    @Override
    public int getResolution() {
        return this.resolution;
    }

    private void addResolution(int n) {
        if (this.supportedResolutions == null) {
            this.supportedResolutions = new ArrayList();
        }
        this.supportedResolutions.add(n);
    }

    @Override
    public List<Integer> getSupportedResolutions() {
        return this.supportedResolutions;
    }

    @Override
    public void setFrame(int n, int n2, int n3, int n4) {
        this.x = n;
        this.y = n2;
        this.width = n3;
        this.height = n4;
    }

    @Override
    public void cancelTransfer() {
        if (this.reporter != null) {
            this.reporter.cancel();
        }
        this._cancelTransfer(this.handle);
    }

    @Override
    public int getFlatbedFunctionalUnit() {
        return this.flatbedFU;
    }

    @Override
    public int getFeederFunctionalUnit() {
        return this.feederFU;
    }

    @Override
    public boolean isDuplexSupported() {
        return this.duplexSupported != 0;
    }

    @Override
    public boolean isDuplexEnabled() {
        return this.duplexEnabled != 0;
    }

    @Override
    public void setDuplexEnabled(boolean bl) {
        this.duplexEnabled = bl ? 1 : 0;
    }

    private class ProgressReporter
    extends TimerTask {
        private int lastStatus = -1;

        private ProgressReporter() {
        }

        public void run() {
            int n = (int)ICAScanner.this._getProgress(ICAScanner.this.handle);
            if (n != this.lastStatus) {
                ((TransferListener)ICAScanner.this.transferDoneListener).transferProgress(n);
                this.lastStatus = n;
            }
        }

        public boolean cancel() {
            this.lastStatus = 100;
            ((TransferListener)ICAScanner.this.transferDoneListener).transferProgress(100);
            return super.cancel();
        }
    }
}

