/*
 * Decompiled with CFR 0.152.
 */
import eu.gnome.morena.Configuration;
import eu.gnome.morena.Device;
import eu.gnome.morena.Manager;
import eu.gnome.morena.Scanner;
import eu.gnome.morena.TransferListener;
import eu.gnome.morena.wia.WIADevice;
import java.awt.image.BufferedImage;
import java.io.File;
import java.util.Arrays;
import java.util.Date;
import java.util.Enumeration;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.LogManager;
import java.util.logging.Logger;
import javax.imageio.ImageIO;

public class MorenaTests
implements TransferListener {
    int pageCount;
    Scanner device;
    Device selectedDevice;
    boolean hasMoreImages;

    public void transferDone(File file) {
        try {
            int n = file.getName().lastIndexOf(46);
            File file2 = new File(file.getParentFile(), "MorenaImg_" + this.pageCount++ + (n > 0 ? file.getName().substring(n) : ""));
            if (file2.exists()) {
                file2.delete();
            }
            boolean bl = file.renameTo(file2);
            System.out.println("image renamed " + bl + "  from : " + file.getAbsolutePath() + "  to : " + file2.getAbsolutePath());
            BufferedImage bufferedImage = ImageIO.read(file2);
            System.out.println("scanned image " + file2.getPath() + " : size=(" + bufferedImage.getWidth() + ", " + bufferedImage.getHeight() + ")   bit mode=" + bufferedImage.getColorModel().getPixelSize());
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    public void transferFailed(int n, String string) {
        System.out.println(n == 0 ? "Feeder empty" : "Transfer failed " + string + " [0x" + Integer.toHexString(n) + "]");
    }

    public void transferProgress(int n) {
        System.out.println(n + "%");
    }

    public static void main(String[] stringArray) {
        MorenaTests morenaTests = new MorenaTests();
        System.out.println("MorenaTests " + Arrays.toString(stringArray) + " started at " + new Date());
        try {
            if (stringArray.length == 0) {
                morenaTests.printProperties();
            } else if (stringArray[0].equalsIgnoreCase("single")) {
                morenaTests.singleScan();
            } else if (stringArray[0].equalsIgnoreCase("batch")) {
                morenaTests.batchScan();
            } else if (stringArray[0].equalsIgnoreCase("thread")) {
                morenaTests.threadScan();
            } else if (stringArray[0].equalsIgnoreCase("event")) {
                morenaTests.eventTest();
            } else if (stringArray[0].equalsIgnoreCase("multi")) {
                morenaTests.multiScan();
            } else if (stringArray[0].equalsIgnoreCase("list")) {
                morenaTests.deviceList();
            } else if (stringArray[0].equalsIgnoreCase("detail")) {
                morenaTests.detailScan();
            } else if (stringArray[0].equalsIgnoreCase("loop")) {
                morenaTests.loopScan();
            }
        }
        catch (Throwable throwable) {
            throwable.printStackTrace();
        }
        System.out.println("... finished");
    }

    private void printProperties() throws Exception {
        System.out.println("phase 1");
        Configuration.addDeviceType(".*fficejet.*", true);
        Configuration.setLogLevel(Level.ALL);
        Manager manager = Manager.getInstance();
        System.out.println("phase 2");
        List<Device> list = manager.listDevices();
        System.out.println("phase 3");
        if (list.size() == 0) {
            System.out.println("No device connected");
        }
        for (int i = 0; i < list.size(); ++i) {
            Device device = list.get(i);
            if (!(device instanceof WIADevice)) continue;
            ((WIADevice)device).displayProperties();
        }
        Thread.sleep(1000L);
        manager.close();
    }

    private void deviceList() {
        System.out.println("phase 1");
        Manager manager = Manager.getInstance();
        System.out.println("phase 2");
        manager.close();
        System.out.println("phase 3");
    }

    private void multiScan() {
        System.out.println("phase 1");
        Configuration.addDeviceType(".*fficejet.*", true);
        Manager manager = Manager.getInstance();
        System.out.println("phase 2");
        List<Device> list = manager.listDevices();
        System.out.println("phase 3");
        if (list.size() > 0) {
            this.device = (Scanner)list.get(0);
            int n = this.device.getFeederFunctionalUnit();
            System.out.println("Feeder unit : " + (n > 0 ? Integer.valueOf(n) : "none"));
            try {
                if (n > 0) {
                    if (this.device.isDuplexSupported()) {
                        this.device.setDuplexEnabled(true);
                    }
                    this.device.startTransfer(this, this.device.getFeederFunctionalUnit());
                } else {
                    this.device.startTransfer(this);
                }
                Thread.sleep(60000L);
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
        }
        System.out.println("phase 4");
        manager.close();
    }

    private void eventTest() throws Exception {
        System.out.println("phase 1");
        Manager manager = Manager.getInstance();
        System.out.println("phase 2");
        this.printDevices(manager);
        System.out.println("phase 3");
        Thread.sleep(30000L);
        this.printDevices(manager);
        Thread.sleep(60000L);
        this.printDevices(manager);
        System.out.println("phase 4");
        manager.close();
        System.out.println("phase 5");
    }

    private void printDevices(Manager manager) {
        System.out.println("----------- connected devices -------------");
        for (Device device : manager.listDevices()) {
            System.out.println(device);
        }
        System.out.println("---------------- cd endlist ---------------");
    }

    private void threadScan() {
    }

    private void batchScan() {
        System.out.println("phase 1");
        Configuration.addDeviceType(".*fficejet.*", true);
        Manager manager = Manager.getInstance();
        List<Device> list = manager.listDevices();
        if (list.size() > 0) {
            Device device = list.get(0);
            if (device != null) {
                boolean bl = false;
                if (device instanceof Scanner) {
                    Scanner scanner = (Scanner)device;
                    scanner.setMode(8);
                    scanner.setResolution(75);
                    try {
                        for (int i = 1; i < 10; ++i) {
                            File file = SynchronousHelper.scanFile(device, 1);
                            int n = file.getName().lastIndexOf(46);
                            File file2 = new File(file.getParentFile(), "MorenaImg_" + i + (n > 0 ? file.getName().substring(n) : ""));
                            if (file2.exists()) {
                                file2.delete();
                            }
                            boolean bl2 = file.renameTo(file2);
                            System.out.println("image renamed " + bl2 + "  from : " + file.getAbsolutePath() + "  to : " + file2.getAbsolutePath());
                        }
                    }
                    catch (Exception exception) {
                        if (exception.getMessage().indexOf("[417]") < 0) {
                            exception.printStackTrace();
                        }
                        System.out.println("No more sheets in the document feeder");
                    }
                }
            }
        } else {
            System.out.println("No device connected!!!");
        }
    }

    private void singleScan() throws Exception {
        System.out.println("phase 1");
        Manager manager = Manager.getInstance();
        System.out.println("phase 2");
        List<Device> list = manager.listDevices();
        System.out.println("phase 3");
        boolean bl = true;
        if (list.size() > 0) {
            Device device = list.get(0);
            File file = SynchronousHelper.scanFile(device, 0);
            int n = file.getName().lastIndexOf(46);
            File file2 = new File(file.getParentFile(), "MorenaImg" + (n > 0 ? file.getName().substring(n) : ""));
            if (file2.exists()) {
                file2.delete();
            }
            boolean bl2 = file.renameTo(file2);
            System.out.println("image renamed " + bl2 + "  from : " + file.getAbsolutePath() + "  to : " + file2.getAbsolutePath());
        }
        System.out.println("phase 4");
        manager.close();
    }

    private void detailScan() throws Exception {
        System.out.println("phase 1");
        Manager manager = Manager.getInstance();
        System.out.println("phase 2");
        List<Device> list = manager.listDevices();
        System.out.println("phase 3");
        boolean bl = false;
        if (list.size() > 0) {
            Scanner scanner = (Scanner)list.get(0);
            int n = 150;
            float f = (float)n / 25.4f;
            int n2 = Math.round(0.0f * f);
            int n3 = Math.round(0.0f * f);
            int n4 = Math.round(210.0f * f);
            int n5 = Math.round(296.0f * f);
            int n6 = -8;
            scanner.setResolution(n);
            scanner.setFrame(n2, n3, n4, n5);
            File file = SynchronousHelper.scanFile(scanner, 0);
            int n7 = file.getName().lastIndexOf(46);
            File file2 = new File(file.getParentFile(), "MorenaImg" + (n7 > 0 ? file.getName().substring(n7) : ""));
            if (file2.exists()) {
                file2.delete();
            }
            boolean bl2 = file.renameTo(file2);
            System.out.println("image renamed " + bl2 + "  from : " + file.getAbsolutePath() + "  to : " + file2.getAbsolutePath());
        }
        System.out.println("phase 4");
        manager.close();
    }

    public void loopScan() throws Exception {
        System.out.println("loop scan phase 1");
        Manager manager = Manager.getInstance();
        System.out.println("phase 2");
        List<Device> list = manager.listDevices();
        System.out.println("phase 3");
        if (list.size() > 0) {
            this.selectedDevice = list.get(0);
            this.scanFujitsu(new FujitsuTransferHandler());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void scanFujitsu(TransferListener transferListener) {
        block12: {
            if (this.selectedDevice != null && this.selectedDevice instanceof Scanner) {
                Scanner scanner = (Scanner)this.selectedDevice;
                scanner.setMode(8);
                scanner.setResolution(100);
                int n = scanner.getFeederFunctionalUnit();
                System.out.println("Feeder unit : " + (n > 0 ? Integer.valueOf(n) : "none"));
                try {
                    if (n > 0) {
                        if (scanner.isDuplexSupported()) {
                            scanner.setDuplexEnabled(true);
                        }
                        this.hasMoreImages = true;
                        while (this.hasMoreImages) {
                            TransferListener transferListener2 = transferListener;
                            synchronized (transferListener2) {
                                scanner.startTransfer(transferListener, n);
                                transferListener.wait();
                            }
                        }
                        break block12;
                    }
                    TransferListener transferListener3 = transferListener;
                    synchronized (transferListener3) {
                        scanner.startTransfer(transferListener);
                        transferListener.wait();
                    }
                }
                catch (Exception exception) {
                    exception.printStackTrace();
                }
            }
        }
    }

    private static void printLoggers() {
        Enumeration<String> enumeration = LogManager.getLogManager().getLoggerNames();
        System.out.println("Loggers :");
        while (enumeration.hasMoreElements()) {
            String string = enumeration.nextElement();
            Logger logger = Logger.getLogger(string);
            System.out.println(string + " " + logger.getLevel() + " parent=" + (logger.getParent() != null ? logger.getParent().getName() : "null") + "  " + logger.getUseParentHandlers());
        }
    }

    class FujitsuTransferHandler
    implements TransferListener {
        boolean transferDoneCalled = false;

        FujitsuTransferHandler() {
        }

        public void transferDone(File file) {
            System.out.println("image file:" + file.getAbsolutePath());
            this.transferDoneCalled = true;
        }

        public void transferFailed(int n, String string) {
            System.out.println(n == 0 ? "Feeder empty" : "Scan error (" + n + ") " + string);
            if (!this.transferDoneCalled) {
                MorenaTests.this.hasMoreImages = false;
            }
            this.transferDoneCalled = false;
            this.notifyRequestor();
        }

        public void transferProgress(int n) {
            System.out.println("transfer progress " + n);
        }

        private synchronized void notifyRequestor() {
            this.notify();
        }
    }
}

