/*
 * Decompiled with CFR 0.152.
 */
package javax.crypto.spec;

import java.security.spec.AlgorithmParameterSpec;

public class RC5ParameterSpec
implements AlgorithmParameterSpec {
    private int version;
    private int rounds;
    private int wordSize;
    private byte[] iv;

    public int getVersion() {
        return this.version;
    }

    public int getRounds() {
        return this.rounds;
    }

    public int getWordSize() {
        return this.wordSize;
    }

    public byte[] getIV() {
        if (this.iv == null) {
            return null;
        }
        byte[] tmp = new byte[this.iv.length];
        System.arraycopy(this.iv, 0, tmp, 0, this.iv.length);
        return tmp;
    }

    public boolean equals(Object obj) {
        if (obj == null || !(obj instanceof RC5ParameterSpec)) {
            return false;
        }
        RC5ParameterSpec spec = (RC5ParameterSpec)obj;
        if (this.version != spec.version) {
            return false;
        }
        if (this.rounds != spec.rounds) {
            return false;
        }
        if (this.wordSize != spec.wordSize) {
            return false;
        }
        if (this.iv != null) {
            if (spec.iv == null || spec.iv.length != this.iv.length) {
                return false;
            }
            int i = 0;
            while (i != this.iv.length) {
                if (this.iv[i] != spec.iv[i]) {
                    return false;
                }
                ++i;
            }
        } else if (spec.iv != null) {
            return false;
        }
        return true;
    }

    public int hashCode() {
        int code = this.version ^ this.rounds ^ this.wordSize;
        if (this.iv != null) {
            int i = 0;
            while (i != this.iv.length) {
                code ^= this.iv[i] << 8 * (i % 4);
                ++i;
            }
        }
        return code;
    }

    public RC5ParameterSpec(int version, int rounds, int wordSize) {
        this.version = version;
        this.rounds = rounds;
        this.wordSize = wordSize;
        this.iv = null;
    }

    public RC5ParameterSpec(int version, int rounds, int wordSize, byte[] iv) {
        this(version, rounds, wordSize, iv, 0);
    }

    public RC5ParameterSpec(int version, int rounds, int wordSize, byte[] iv, int offset) {
        this.version = version;
        this.rounds = rounds;
        this.wordSize = wordSize;
        this.iv = new byte[2 * (wordSize / 8)];
        System.arraycopy(iv, offset, this.iv, 0, this.iv.length);
    }
}

