/*
 * Decompiled with CFR 0.152.
 */
package eu.gnome.morena.ica;

import eu.gnome.morena.Configuration;
import eu.gnome.morena.Device;
import eu.gnome.morena.Manager;
import eu.gnome.morena.ica.ICACamera;
import eu.gnome.morena.ica.ICAConstants;
import eu.gnome.morena.ica.ICADevice;
import eu.gnome.morena.ica.ICAScanner;
import java.util.List;
import java.util.Vector;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ICAManager
extends Manager
implements ICAConstants {
    public static final ICAManager INSTANCE = new ICAManager();
    private boolean isInitialized = false;
    private boolean isAvailable = false;
    private List<Device> devices = new Vector<Device>();

    private native void _initialize();

    private native void _close();

    private void add(String string, long l, int n) {
        ICADevice iCADevice = Configuration.isScanner(string, (n & 2) != 0) ? new ICAScanner(string, l) : new ICACamera(string, l);
        this.devices.add(iCADevice);
        this.fireDeviceConnected(iCADevice);
        Manager.debug("Adding device 0x" + Long.toHexString(l) + " " + string);
    }

    private void remove(String string, long l) {
        for (Device device : this.devices) {
            if (!string.equals(((Object)device).toString())) continue;
            this.devices.remove(device);
            this.fireDeviceDisconnected(device);
            Manager.debug("Removing device 0x" + Long.toHexString(l) + " " + string);
            break;
        }
    }

    private ICAManager() {
    }

    @Override
    public List<Device> listDevices() {
        return this.devices;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean available() {
        if (!this.isInitialized) {
            try {
                this._initialize();
                this.isAvailable = true;
                ICAManager iCAManager = this;
                synchronized (iCAManager) {
                    this.wait(1000L);
                }
            }
            catch (Throwable throwable) {
            }
            finally {
                this.isInitialized = true;
            }
        }
        return this.isAvailable;
    }

    @Override
    public void close() {
        this._close();
    }

    public String toString() {
        return "ICA";
    }
}

