/*
 * Decompiled with CFR 0.152.
 */
package org.mustangproject.ZUGFeRD;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.math.BigDecimal;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Collections;
import java.util.GregorianCalendar;
import javax.xml.transform.TransformerException;
import org.apache.jempbox.xmp.XMPMetadata;
import org.apache.jempbox.xmp.XMPSchema;
import org.apache.jempbox.xmp.XMPSchemaBasic;
import org.apache.jempbox.xmp.XMPSchemaDublinCore;
import org.apache.jempbox.xmp.XMPSchemaPDF;
import org.apache.jempbox.xmp.pdfa.XMPSchemaPDFAId;
import org.apache.pdfbox.cos.COSArray;
import org.apache.pdfbox.cos.COSBase;
import org.apache.pdfbox.cos.COSDictionary;
import org.apache.pdfbox.pdmodel.PDDocument;
import org.apache.pdfbox.pdmodel.PDDocumentCatalog;
import org.apache.pdfbox.pdmodel.PDDocumentInformation;
import org.apache.pdfbox.pdmodel.PDDocumentNameDictionary;
import org.apache.pdfbox.pdmodel.PDEmbeddedFilesNameTreeNode;
import org.apache.pdfbox.pdmodel.common.COSObjectable;
import org.apache.pdfbox.pdmodel.common.PDMetadata;
import org.apache.pdfbox.pdmodel.common.filespecification.PDComplexFileSpecification;
import org.apache.pdfbox.pdmodel.common.filespecification.PDEmbeddedFile;
import org.mustangproject.ZUGFeRD.IZUGFeRDExportableItem;
import org.mustangproject.ZUGFeRD.IZUGFeRDExportableTransaction;
import org.mustangproject.ZUGFeRD.XMPSchemaPDFAExtensions;
import org.mustangproject.ZUGFeRD.XMPSchemaZugferd;

public class ZUGFeRDExporter {
    private String conformanceLevel = "U";
    private String versionStr = "1.0";

    private String currencyFormat(BigDecimal value, char decimalDelimiter) {
        value = value.setScale(2, 4);
        long totalCent = value.multiply(new BigDecimal(100)).intValue();
        long eurOnly = value.longValue();
        long centOnly = Math.abs(totalCent % 100L);
        StringBuffer res = new StringBuffer();
        res.append(eurOnly);
        res.append(decimalDelimiter);
        if (centOnly < 10L) {
            res.append('0');
        }
        res.append(centOnly);
        return res.toString();
    }

    public void setConformanceLevel(String newLevel) {
        this.conformanceLevel = newLevel;
    }

    public PDDocumentCatalog PDFmakeA3compliant(PDDocument doc, String producer, String creator, boolean attachZugferdHeaders) throws IOException, TransformerException {
        String fullProducer = producer + "(via mustangproject.org " + this.versionStr + ")";
        PDDocumentCatalog cat = doc.getDocumentCatalog();
        PDMetadata metadata = new PDMetadata(doc);
        cat.setMetadata(metadata);
        XMPMetadata xmp = new XMPMetadata();
        XMPSchemaPDFAId pdfaid = new XMPSchemaPDFAId(xmp);
        pdfaid.setAbout("");
        xmp.addSchema((XMPSchema)pdfaid);
        XMPSchemaDublinCore dc = xmp.addDublinCoreSchema();
        dc.addCreator(creator);
        dc.setAbout("");
        XMPSchemaBasic xsb = xmp.addBasicSchema();
        xsb.setAbout("");
        xsb.setCreatorTool(creator);
        xsb.setCreateDate(GregorianCalendar.getInstance());
        PDDocumentInformation pdi = new PDDocumentInformation();
        pdi.setProducer(fullProducer);
        pdi.setAuthor(creator);
        doc.setDocumentInformation(pdi);
        XMPSchemaPDF pdf = xmp.addPDFSchema();
        pdf.setProducer(fullProducer);
        pdf.setAbout("");
        pdfaid.setConformance(this.conformanceLevel);
        pdfaid.setPart(Integer.valueOf(3));
        if (attachZugferdHeaders) {
            this.addZugferdXMP(xmp);
        }
        metadata.importXMPMetadata(xmp);
        return cat;
    }

    private String getZugferdXMLForTransaction(IZUGFeRDExportableTransaction trans) {
        SimpleDateFormat zugferdDateFormat = new SimpleDateFormat("yyyyMMdd");
        String xml = "\ufeff<?xml version=\"1.0\" encoding=\"UTF-8\"?>\n<rsm:CrossIndustryDocument xmlns:xsi=\"http://www.w3.org/2001/XMLSchema-instance\" xmlns:rsm=\"urn:ferd:CrossIndustryDocument:invoice:1p0\" xsi:schemaLocation=\"urn:ferd:CrossIndustryDocument:invoice:1p0 ../Schema/ZUGFeRD_1p0.xsd\" xmlns:ram=\"urn:un:unece:uncefact:data:standard:ReusableAggregateBusinessInformationEntity:12\" xmlns:udt=\"urn:un:unece:uncefact:data:standard:UnqualifiedDataType:15\">\n\t<rsm:SpecifiedExchangedDocumentContext>\n\t\t<ram:TestIndicator><udt:Indicator>false</udt:Indicator></ram:TestIndicator>\n\t\t<ram:GuidelineSpecifiedDocumentContextParameter>\n\t\t\t<ram:ID>urn:ferd:invoice:rc:comfort</ram:ID>\n\t\t</ram:GuidelineSpecifiedDocumentContextParameter>\n\t</rsm:SpecifiedExchangedDocumentContext>\n\t<rsm:HeaderExchangedDocument>\n\t\t<ram:ID>" + trans.getNumber() + "</ram:ID>\n" + "\t\t<ram:Name>RECHNUNG</ram:Name>\n" + "\t\t<ram:TypeCode>380</ram:TypeCode>\n" + "\t\t<ram:IssueDateTime><udt:DateTimeString format=\"102\">" + zugferdDateFormat.format(trans.getIssueDate()) + "</udt:DateTimeString></ram:IssueDateTime>\n" + "\t</rsm:HeaderExchangedDocument>\n" + "\t<rsm:SpecifiedSupplyChainTradeTransaction>\n" + "\t\t<ram:ApplicableSupplyChainTradeAgreement>\n" + "\t\t\t<ram:SellerTradeParty>\n" + "\t\t\t\t<ram:Name>" + trans.getOwnOrganisationName() + "</ram:Name>\n" + "\t\t\t\t<ram:PostalTradeAddress>\n" + "\t\t\t\t\t<ram:PostcodeCode>" + trans.getOwnZIP() + "</ram:PostcodeCode>\n" + "\t\t\t\t\t<ram:LineOne>" + trans.getOwnStreet() + "</ram:LineOne>\n" + "\t\t\t\t\t<ram:CityName>" + trans.getOwnLocation() + "</ram:CityName>\n" + "\t\t\t\t\t<ram:CountryID>" + trans.getOwnCountry() + "</ram:CountryID>\n" + "\t\t\t\t</ram:PostalTradeAddress>\n" + "\t\t\t\t<ram:SpecifiedTaxRegistration>\n" + "\t\t\t\t\t<ram:ID schemeID=\"FC\">" + trans.getOwnTaxID() + "</ram:ID>\n" + "\t\t\t\t</ram:SpecifiedTaxRegistration>\n" + "\t\t\t\t<ram:SpecifiedTaxRegistration>\n" + "\t\t\t\t\t<ram:ID schemeID=\"VA\">" + trans.getOwnVATID() + "</ram:ID>\n" + "\t\t\t\t</ram:SpecifiedTaxRegistration>\n" + "\t\t\t</ram:SellerTradeParty>\n" + "\t\t\t<ram:BuyerTradeParty>\n" + "\t\t\t\t<ram:Name>" + trans.getRecipient().getName() + "</ram:Name>\n" + "\t\t\t\t<ram:PostalTradeAddress>\n" + "\t\t\t\t\t<ram:PostcodeCode>" + trans.getRecipient().getZIP() + "</ram:PostcodeCode>\n" + "\t\t\t\t\t<ram:LineOne>" + trans.getRecipient().getStreet() + "</ram:LineOne>\n" + "\t\t\t\t\t<ram:CityName>" + trans.getRecipient().getLocation() + "</ram:CityName>\n" + "\t\t\t\t\t<ram:CountryID>" + trans.getRecipient().getCountry() + "</ram:CountryID>\n" + "\t\t\t\t</ram:PostalTradeAddress>\n" + "\t\t\t\t<ram:SpecifiedTaxRegistration>\n" + "\t\t\t\t\t<ram:ID schemeID=\"VA\">" + trans.getRecipient().getVATID() + "</ram:ID>\n" + "\t\t\t\t</ram:SpecifiedTaxRegistration>\n" + "\t\t\t</ram:BuyerTradeParty>\n" + "\t\t</ram:ApplicableSupplyChainTradeAgreement>\n" + "\t\t<ram:ApplicableSupplyChainTradeDelivery>\n" + "\t\t\t<ram:ActualDeliverySupplyChainEvent>\n" + "\t\t\t\t<ram:OccurrenceDateTime><udt:DateTimeString format=\"102\">" + zugferdDateFormat.format(trans.getDeliveryDate()) + "</udt:DateTimeString></ram:OccurrenceDateTime>\n" + "\t\t\t</ram:ActualDeliverySupplyChainEvent>\n" + "\t\t</ram:ApplicableSupplyChainTradeDelivery>\n" + "\t\t<ram:ApplicableSupplyChainTradeSettlement>\n" + "\t\t\t<ram:PaymentReference>" + trans.getNumber() + "</ram:PaymentReference>\n" + "\t\t\t<ram:InvoiceCurrencyCode>EUR</ram:InvoiceCurrencyCode>\n" + "\t\t\t<ram:SpecifiedTradeSettlementPaymentMeans>\n" + "\t\t\t\t<ram:TypeCode>42</ram:TypeCode>\n" + "\t\t\t\t<ram:Information>\u00dcberweisung</ram:Information>\n" + "\t\t\t\t<ram:PayeePartyCreditorFinancialAccount>\n" + "\t\t\t\t\t<ram:IBANID>" + trans.getOwnIBAN() + "</ram:IBANID>\n" + "\t\t\t\t</ram:PayeePartyCreditorFinancialAccount>\n" + "\t\t\t\t<ram:PayeeSpecifiedCreditorFinancialInstitution>\n" + "\t\t\t\t\t<ram:BICID>" + trans.getOwnBIC() + "</ram:BICID>\n" + "\t\t\t\t\t<ram:Name>" + trans.getOwnBankName() + "</ram:Name>\n" + "\t\t\t\t</ram:PayeeSpecifiedCreditorFinancialInstitution>\n" + "\t\t\t</ram:SpecifiedTradeSettlementPaymentMeans>\n";
        xml = xml + "\t\t\t<ram:SpecifiedTradePaymentTerms>\n" + "\t\t\t\t<ram:DueDateDateTime><udt:DateTimeString format=\"102\">" + zugferdDateFormat.format(trans.getDueDate()) + "</udt:DateTimeString></ram:DueDateDateTime>\n" + "\t\t\t</ram:SpecifiedTradePaymentTerms>\n" + "\t\t\t<ram:SpecifiedTradeSettlementMonetarySummation>\n" + "\t\t\t\t<ram:LineTotalAmount currencyID=\"EUR\">" + this.currencyFormat(trans.getTotal(), '.') + "</ram:LineTotalAmount>\n" + "\t\t\t\t<ram:TaxBasisTotalAmount currencyID=\"EUR\">" + this.currencyFormat(trans.getTotal(), '.') + "</ram:TaxBasisTotalAmount>\n" + "\t\t\t\t<ram:TaxTotalAmount currencyID=\"EUR\">" + this.currencyFormat(trans.getTotalGross().subtract(trans.getTotal()), '.') + "</ram:TaxTotalAmount>\n" + "\t\t\t\t<ram:GrandTotalAmount currencyID=\"EUR\">" + this.currencyFormat(trans.getTotalGross(), '.') + "</ram:GrandTotalAmount>\n" + "\t\t\t\t<ram:DuePayableAmount currencyID=\"EUR\">" + this.currencyFormat(trans.getTotalGross(), '.') + "</ram:DuePayableAmount>\n" + "\t\t\t</ram:SpecifiedTradeSettlementMonetarySummation>\n" + "\t\t</ram:ApplicableSupplyChainTradeSettlement>\n";
        int lineID = 0;
        for (IZUGFeRDExportableItem currentItem : trans.getZFItems()) {
            xml = xml + "\t\t<ram:IncludedSupplyChainTradeLineItem>\n" + "\t\t\t<ram:AssociatedDocumentLineDocument>\n" + "\t\t\t\t<ram:LineID>" + ++lineID + "</ram:LineID>\n" + "\t\t\t</ram:AssociatedDocumentLineDocument>\n" + "\t\t\t<ram:SpecifiedSupplyChainTradeAgreement>\n" + "\t\t\t\t<ram:GrossPriceProductTradePrice>\n" + "\t\t\t\t\t<ram:ChargeAmount currencyID=\"EUR\">" + this.currencyFormat(currentItem.getPriceGross(), '.') + "</ram:ChargeAmount>\n" + "\t\t\t\t\t<ram:BasisQuantity unitCode=\"" + currentItem.getProduct().getUnit() + "\">1</ram:BasisQuantity>\n" + "\t\t\t\t</ram:GrossPriceProductTradePrice>\n" + "\t\t\t\t<ram:NetPriceProductTradePrice>\n" + "\t\t\t\t\t<ram:ChargeAmount currencyID=\"EUR\">" + this.currencyFormat(currentItem.getPrice(), '.') + "</ram:ChargeAmount>\n" + "\t\t\t\t\t<ram:BasisQuantity unitCode=\"" + currentItem.getProduct().getUnit() + "\">1</ram:BasisQuantity>\n" + "\t\t\t\t</ram:NetPriceProductTradePrice>\n" + "\t\t\t</ram:SpecifiedSupplyChainTradeAgreement>\n" + "\t\t\t<ram:SpecifiedSupplyChainTradeDelivery>\n" + "\t\t\t\t<ram:BilledQuantity unitCode=\"" + currentItem.getProduct().getUnit() + "\">" + currentItem.getQuantity() + "</ram:BilledQuantity>\n" + "\t\t\t</ram:SpecifiedSupplyChainTradeDelivery>\n" + "\t\t\t<ram:SpecifiedSupplyChainTradeSettlement>\n" + "\t\t\t\t<ram:ApplicableTradeTax>\n" + "\t\t\t\t\t<ram:TypeCode>VAT</ram:TypeCode>\n" + "\t\t\t\t\t<ram:CategoryCode>S</ram:CategoryCode>\n" + "\t\t\t\t\t<ram:ApplicablePercent>" + currentItem.getProduct().getVATPercent() + "</ram:ApplicablePercent>\n" + "\t\t\t\t</ram:ApplicableTradeTax>\n" + "\t\t\t\t<ram:SpecifiedTradeSettlementMonetarySummation>\n" + "\t\t\t\t\t<ram:LineTotalAmount currencyID=\"EUR\">" + this.currencyFormat(currentItem.getTotalGross(), '.') + "</ram:LineTotalAmount>\n" + "\t\t\t\t</ram:SpecifiedTradeSettlementMonetarySummation>\n" + "\t\t\t</ram:SpecifiedSupplyChainTradeSettlement>\n" + "\t\t\t<ram:SpecifiedTradeProduct>\n" + "\t\t\t\t<ram:Name>" + currentItem.getProduct().getName() + "</ram:Name>\n" + "\t\t\t\t<ram:Description>" + currentItem.getProduct().getDescription() + "</ram:Description>\n" + "\t\t\t</ram:SpecifiedTradeProduct>\n" + "\t\t</ram:IncludedSupplyChainTradeLineItem>\n";
        }
        xml = xml + "\t</rsm:SpecifiedSupplyChainTradeTransaction>\n" + "</rsm:CrossIndustryDocument>";
        return xml;
    }

    public void PDFattachZugferdFile(PDDocument doc, IZUGFeRDExportableTransaction trans) throws IOException {
        byte[] zugferdData;
        PDEmbeddedFilesNameTreeNode efTree = new PDEmbeddedFilesNameTreeNode();
        String filename = "ZUGFeRD-invoice.xml";
        PDComplexFileSpecification fs = new PDComplexFileSpecification();
        fs.setFile(filename);
        COSDictionary dict = fs.getCOSDictionary();
        dict.setName("AFRelationship", "Alternative");
        dict.setString("UF", filename);
        byte[] zugferdRaw = this.getZugferdXMLForTransaction(trans).getBytes("UTF-8");
        if (zugferdRaw[0] == -17 && zugferdRaw[1] == -69 && zugferdRaw[2] == -65) {
            zugferdData = new byte[zugferdRaw.length - 3];
            System.arraycopy(zugferdRaw, 3, zugferdData, 0, zugferdRaw.length - 3);
        } else {
            zugferdData = zugferdRaw;
        }
        ByteArrayInputStream fakeFile = new ByteArrayInputStream(zugferdData);
        PDEmbeddedFile ef = new PDEmbeddedFile(doc, (InputStream)fakeFile);
        ef.setSubtype("text/xml");
        ef.setSize(zugferdData.length);
        ef.setCreationDate((Calendar)new GregorianCalendar());
        ef.setModDate(GregorianCalendar.getInstance());
        fs.setEmbeddedFile(ef);
        efTree.setNames(Collections.singletonMap(filename, fs));
        PDDocumentNameDictionary names = new PDDocumentNameDictionary(doc.getDocumentCatalog());
        names.setEmbeddedFiles(efTree);
        doc.getDocumentCatalog().setNames(names);
        COSArray cosArray = new COSArray();
        cosArray.add((COSObjectable)fs);
        doc.getDocumentCatalog().getCOSDictionary().setItem("AF", (COSBase)cosArray);
    }

    private void addZugferdXMP(XMPMetadata metadata) {
        XMPSchemaZugferd zf = new XMPSchemaZugferd(metadata);
        zf.setAbout("");
        metadata.addSchema((XMPSchema)zf);
        XMPSchemaPDFAExtensions pdfaex = new XMPSchemaPDFAExtensions(metadata);
        pdfaex.setAbout("");
        metadata.addSchema((XMPSchema)pdfaex);
    }
}

