/*
 * Decompiled with CFR 0.152.
 */
package eu.gnome.morena.wia;

import eu.gnome.morena.Configuration;
import eu.gnome.morena.Device;
import eu.gnome.morena.Manager;
import eu.gnome.morena.wia.WIACamera;
import eu.gnome.morena.wia.WIADevice;
import eu.gnome.morena.wia.WIAScanner;
import java.util.Iterator;
import java.util.List;
import java.util.Vector;
import java.util.logging.Level;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class WIAManager
extends Manager
implements Runnable {
    private long handle = 0L;
    private boolean isInitialized = false;
    private List<Device> devices = new Vector<Device>();
    private static int mode = 0;
    public static final WIAManager INSTANCE = new WIAManager();
    private Thread poll = null;

    private native long _initialize(int var1, boolean var2) throws Exception;

    private native void _release() throws Exception;

    private synchronized native void _poll();

    @Override
    public synchronized void run() {
        Manager.debug("Poll thread started");
        try {
            while (true) {
                this.wait(3000L);
                this.listDevices();
            }
        }
        catch (Exception exception) {
            Manager.debug("Poll thread finished: " + exception.toString());
            return;
        }
    }

    private void add(String string, int n, String string2) {
        for (Device device : this.devices) {
            if (!((WIADevice)device).UID.equals(string)) continue;
            ((WIADevice)device).available = true;
            return;
        }
        WIADevice wIADevice = Configuration.isScanner(string2, (n & 1) != 0) ? new WIAScanner(string2, string) : new WIACamera(string2, string);
        this.devices.add(wIADevice);
        this.fireDeviceConnected(wIADevice);
        Manager.debug("Adding device " + string + " \"" + string2 + "\" Type=" + Integer.toHexString(n));
    }

    private void remove(String string, String string2) {
        for (Device device : this.devices) {
            if (!((WIADevice)device).UID.equals(string)) continue;
            this.devices.remove(device);
            WIAManager.debug("Removing device " + string + " \"" + string2);
            ((WIADevice)device).release();
            this.fireDeviceDisconnected(device);
            return;
        }
    }

    private WIAManager() {
    }

    @Override
    public void close() {
        if (this.isInitialized) {
            try {
                for (Device device : this.devices) {
                    ((WIADevice)device).release();
                }
                this.devices.clear();
                this._release();
                this.isInitialized = false;
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        WIAManager.debug("WIA" + wiaver + " closed.");
    }

    @Override
    public synchronized List<Device> listDevices() {
        if (this.available()) {
            if (WIAManager.isPollEnabled() || wiaver == 1 && WIAManager.isNativeUIEnabled()) {
                for (Device iterator2 : this.devices) {
                    ((WIADevice)iterator2).available = false;
                }
                this._poll();
                Vector vector = new Vector();
                for (Device device : this.devices) {
                    if (((WIADevice)device).available) continue;
                    vector.add((WIADevice)device);
                }
                Iterator iterator = vector.iterator();
                while (iterator.hasNext()) {
                    Device device;
                    device = (WIADevice)iterator.next();
                    this.remove(((WIADevice)device).UID, ((Object)device).toString());
                }
            }
            return this.devices;
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean available() {
        if (!this.isInitialized) {
            try {
                mode = Configuration.getMode();
                WIAManager.debug("Initializing WIA" + wiaver + " ...");
                this.handle = this._initialize(mode, Configuration.getLogLevel().equals(Level.ALL));
                if (WIAManager.isPollEnabled()) {
                    this.poll = new Thread((Runnable)this, "WIA device tree scanner");
                    this.poll.setDaemon(true);
                    this.poll.start();
                }
            }
            catch (Throwable throwable) {
            }
            finally {
                this.isInitialized = true;
            }
        }
        return this.handle != 0L;
    }

    public String toString() {
        return "WIA";
    }

    public static int getVersion() {
        return wiaver;
    }

    public static boolean isNativeUIEnabled() {
        return (mode & 1) > 0;
    }

    public static boolean isPollEnabled() {
        return wiaver == 1 && (mode & 2) > 0;
    }
}

