/*
 * Decompiled with CFR 0.152.
 */
import eu.gnome.morena.Device;
import eu.gnome.morena.DeviceBase;
import eu.gnome.morena.TransferListener;
import java.io.File;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.atomic.AtomicInteger;

public class ScanSession {
    MultiFileTransferHandler th;
    private LinkedBlockingQueue<String> queue;
    boolean transferFinished = false;
    private AtomicInteger blockedThreadCount;
    public static final String EOP = "";

    public void startSession(Device device, int n) throws Exception {
        this.queue = new LinkedBlockingQueue();
        this.blockedThreadCount = new AtomicInteger(0);
        this.transferFinished = false;
        this.th = new MultiFileTransferHandler();
        ((DeviceBase)device).startTransfer(this.th, n);
    }

    public File getImageFile() {
        String string = this.queue.poll();
        if (string == null && !this.transferFinished) {
            try {
                this.blockedThreadCount.incrementAndGet();
                string = this.queue.take();
                this.blockedThreadCount.decrementAndGet();
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        }
        if (string.isEmpty()) {
            this.releaseBlockedThreads();
        }
        return string == null || string.isEmpty() ? null : new File(string);
    }

    public boolean isEmptyFeeder() {
        return this.th != null ? this.th.code == 0 : false;
    }

    public int getErrorCode() {
        return this.th.code;
    }

    public String getErrorMessage() {
        return this.th.error;
    }

    private void releaseBlockedThreads() {
        int n = this.blockedThreadCount.getAndSet(0);
        if (n > 0) {
            for (int i = 0; i < n; ++i) {
                try {
                    this.queue.put(EOP);
                    continue;
                }
                catch (InterruptedException interruptedException) {
                    interruptedException.printStackTrace();
                }
            }
        }
    }

    public static String getExt(File file) {
        String string = file.getName();
        int n = string.lastIndexOf(46);
        if (n > 0 && n + 1 < string.length()) {
            return string.substring(n + 1);
        }
        return EOP;
    }

    class MultiFileTransferHandler
    implements TransferListener {
        int code = -1;
        String error = "No error";
        long time = System.currentTimeMillis();
        int pcounter = 0;

        public void transferDone(File file) {
            boolean bl;
            String string;
            String string2 = file.getParent();
            File file2 = new File(string2, this.getUniqueFileName("mi", string = ScanSession.getExt(file)));
            if (file2.exists()) {
                // empty if block
            }
            if (!(bl = file.renameTo(file2))) {
                System.out.println("Cannot rename the file " + file + "  to  " + file2);
                return;
            }
            try {
                ScanSession.this.queue.put(file2.getAbsolutePath());
            }
            catch (InterruptedException interruptedException) {
                interruptedException.printStackTrace();
            }
        }

        public void transferProgress(int n) {
            System.out.println("transfer " + n + "%");
        }

        public void transferFailed(int n, String string) {
            this.code = n;
            this.error = string;
            ScanSession.this.transferFinished = true;
            try {
                ScanSession.this.queue.put(ScanSession.EOP);
            }
            catch (InterruptedException interruptedException) {
                interruptedException.printStackTrace();
            }
        }

        private synchronized String getUniqueFileName(String string, String string2) {
            return new String(string + "_" + this.time + "_" + ++this.pcounter + (!string2.isEmpty() ? "." + string2 : ScanSession.EOP));
        }
    }
}

