/*
 * Decompiled with CFR 0.152.
 */
package eu.gnome.morena.wia;

import eu.gnome.morena.Configuration;
import eu.gnome.morena.Manager;
import eu.gnome.morena.MorenaException;
import eu.gnome.morena.Scanner;
import eu.gnome.morena.TransferDoneListener;
import eu.gnome.morena.TransferListener;
import eu.gnome.morena.wia.SupportedPropertyValues;
import eu.gnome.morena.wia.WIADevice;
import eu.gnome.morena.wia.WIAItem;
import eu.gnome.morena.wia.WIAManager;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class WIAScanner
extends WIADevice
implements Scanner,
Runnable {
    private int bitDepth = 8;
    private int resolution = 50;
    private int x = -1;
    private int y = -1;
    private int width = -1;
    private int height = -1;
    private int brightness = 0;
    private int contrast = 0;
    private int handlingCapab;
    private int handlingSelect;
    private int duplex;
    private int[] scanProps;
    private List<Integer> extPropList;
    private static final int[] BASIC_PROPERTIES = new int[]{6147, 6148, 4103, 4104, 6154, 6155};

    private native long _initialize(String var1) throws Exception;

    private native void _transfer(long var1, boolean var3, int var4, boolean var5, int[] var6) throws MorenaException;

    private native void _cancelTransfer(long var1);

    WIAScanner(String string, String string2) {
        super(string, string2);
        try {
            this.handle = this._initialize(string2);
        }
        catch (Exception exception) {
            Manager.error("Error while initializing scanner: " + string, exception);
        }
        this.available = true;
        this.extPropList = new ArrayList<Integer>();
        if (this.functionalUnit >= 0 && this.functionalUnit < this.items.size()) {
            WIAItem wIAItem = (WIAItem)this.items.get(this.functionalUnit);
            SupportedPropertyValues supportedPropertyValues = wIAItem.getProperty(4104);
            if (supportedPropertyValues != null && !supportedPropertyValues.isNone()) {
                switch (supportedPropertyValues.isCurrentValueSet() ? supportedPropertyValues.getCurrentValue() : supportedPropertyValues.getDefaultValue()) {
                    case 1: {
                        this.bitDepth = -1;
                        break;
                    }
                    case 8: {
                        this.bitDepth = -8;
                        break;
                    }
                    case 24: {
                        this.bitDepth = 8;
                        break;
                    }
                    default: {
                        this.bitDepth = 8;
                    }
                }
            }
            if ((supportedPropertyValues = wIAItem.getProperty(6147)) != null && !supportedPropertyValues.isNone()) {
                this.resolution = supportedPropertyValues.isCurrentValueSet() ? supportedPropertyValues.getCurrentValue() : supportedPropertyValues.getDefaultValue();
            }
        } else {
            WIAManager.error("WIAScanner<init> wrong default FU " + this.functionalUnit + " > " + this.items.size());
        }
    }

    protected void addItem(String string, int n) {
        WIAItem wIAItem = new WIAItem(string, n);
        this.items.add(wIAItem);
        Manager.debug("Adding item : " + string + "  category " + n);
    }

    protected void addItemProperty(int n, int n2, String string, boolean bl, int n3, int n4, int[] nArray) {
        WIAItem wIAItem = (WIAItem)this.items.get(n);
        wIAItem.addProperty(n2, string, bl, n3, n4, nArray);
    }

    protected void transfer() {
        try {
            this._transfer(this.handle, (Configuration.getMode() & 1) > 0, this.functionalUnit, this.transferDoneListener instanceof TransferListener, this.scanProps);
        }
        catch (MorenaException morenaException) {
            this.transferDoneListener.transferFailed(morenaException.getErrorCode(), morenaException.getMessage());
        }
        catch (Throwable throwable) {
            this.transferDoneListener.transferFailed(-1, throwable.toString());
        }
    }

    @Override
    public void run() {
        this.transfer();
    }

    @Override
    public void startTransfer(TransferDoneListener transferDoneListener, int n) throws Exception {
        super.startTransfer(transferDoneListener, n);
        ArrayList<Integer> arrayList = new ArrayList<Integer>(20);
        for (int n2 : BASIC_PROPERTIES) {
            arrayList.add(n2);
        }
        if (this.x != -1) {
            arrayList.add(6149);
        }
        if (this.y != -1) {
            arrayList.add(6150);
        }
        if (this.width != -1) {
            arrayList.add(6151);
        }
        if (this.height != -1) {
            arrayList.add(6152);
        }
        arrayList.addAll(this.extPropList);
        Object object = new ArrayList(arrayList.size());
        WIAItem wIAItem = WIAManager.getVersion() == 1 ? (WIAItem)this.items.get(0) : (WIAItem)this.items.get(n);
        Iterator iterator = arrayList.iterator();
        while (iterator.hasNext()) {
            int n2;
            n2 = (Integer)iterator.next();
            SupportedPropertyValues supportedPropertyValues = wIAItem.getProperty(n2);
            if (Configuration.checkWriteable() && (supportedPropertyValues == null || !supportedPropertyValues.isWritable())) continue;
            ((ArrayList)object).add(n2);
        }
        this.scanProps = new int[((ArrayList)object).size()];
        int n3 = 0;
        Iterator iterator2 = ((ArrayList)object).iterator();
        while (iterator2.hasNext()) {
            int n4 = (Integer)iterator2.next();
            this.scanProps[n3++] = n4;
        }
        Manager.trace("Properties " + Arrays.toString(this.scanProps));
        new Thread(this).start();
    }

    @Override
    public void setMode(int n) {
        this.bitDepth = n;
    }

    @Override
    public int getMode() {
        return this.bitDepth;
    }

    @Override
    public List<Integer> getSupportedModes() {
        return this.getCurrentItem() != null ? this.getCurrentItem().getSupportedModes() : new ArrayList();
    }

    @Override
    public void setResolution(int n) {
        this.resolution = n;
    }

    @Override
    public int getResolution() {
        return this.resolution;
    }

    @Override
    public List<Integer> getSupportedResolutions() {
        return this.getCurrentItem() != null ? this.getCurrentItem().getSupportedValues(6147) : new ArrayList();
    }

    @Override
    public void setFrame(int n, int n2, int n3, int n4) {
        this.x = n;
        this.y = n2;
        this.width = n3;
        this.height = n4;
    }

    @Override
    public void cancelTransfer() {
        this._cancelTransfer(this.handle);
    }

    @Override
    public int getFlatbedFunctionalUnit() {
        if (WIAManager.getVersion() == 1 && (this.handlingCapab & 2) > 0) {
            return 2;
        }
        if (WIAManager.getVersion() == 2) {
            for (int i = 0; i < this.items.size(); ++i) {
                WIAItem wIAItem = (WIAItem)this.items.get(i);
                if (!wIAItem.isFlatbed()) continue;
                return i;
            }
        }
        return -1;
    }

    @Override
    public int getFeederFunctionalUnit() {
        if (WIAManager.getVersion() == 1 && (this.handlingCapab & 1) > 0) {
            return 1;
        }
        if (WIAManager.getVersion() == 2) {
            for (int i = 0; i < this.items.size(); ++i) {
                WIAItem wIAItem = (WIAItem)this.items.get(i);
                if (!wIAItem.isFeeder()) continue;
                return i;
            }
        }
        return -1;
    }

    @Override
    public boolean isDuplexSupported() {
        return (this.handlingCapab & 4) > 0;
    }

    @Override
    public boolean isDuplexEnabled() {
        return this.duplex != 0;
    }

    @Override
    public void setDuplexEnabled(boolean bl) {
        this.duplex = bl ? 1 : 0;
    }

    public int getBrightness() {
        return this.brightness;
    }

    public void setBrightness(int n) {
        this.brightness = n;
    }

    public int getContrast() {
        return this.contrast;
    }

    public void setContrast(int n) {
        this.contrast = n;
    }

    public int getHandlingCapab() {
        return this.handlingCapab;
    }

    public int getHandlingSelect() {
        return this.handlingSelect;
    }

    public SupportedPropertyValues getPropertyValues(int n) {
        return this.getCurrentItem() != null ? this.getCurrentItem().getProperty(n) : null;
    }

    private WIAItem getCurrentItem() {
        int n;
        int n2 = n = WIAManager.getVersion() == 1 && (this.handlingCapab & 1) > 0 ? 0 : this.functionalUnit;
        if (this.items.size() > n) {
            return (WIAItem)this.items.get(n);
        }
        return null;
    }
}

