/*
 * Decompiled with CFR 0.152.
 */
import eu.gnome.morena.Camera;
import eu.gnome.morena.Device;
import eu.gnome.morena.Manager;
import eu.gnome.morena.Scanner;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.File;
import java.io.FileOutputStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.List;
import javax.imageio.ImageIO;

public class MorenaExample {
    static Manager manager;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void main(String[] stringArray) {
        MorenaExample morenaExample = new MorenaExample();
        System.out.println("MorenaExample(" + Arrays.toString(stringArray) + ") ... started at " + new Date());
        try {
            manager = Manager.getInstance();
            if (stringArray.length == 0) {
                morenaExample.simpleScan();
            } else if (stringArray[0].equalsIgnoreCase("batch")) {
                morenaExample.batchScan();
            }
        }
        catch (Throwable throwable) {
            throwable.printStackTrace();
        }
        finally {
            manager.close();
        }
        System.out.println("Finished.");
    }

    private void simpleScan() throws Exception {
        List<Device> list = manager.listDevices();
        if (list.size() > 0) {
            Device device = list.get(0);
            if (device != null) {
                Object object;
                if (device instanceof Scanner) {
                    object = (Scanner)device;
                    object.setMode(8);
                    object.setResolution(75);
                    object.setFrame(0, 0, 622, 874);
                } else if (device instanceof Camera) {
                    // empty if block
                }
                object = SynchronousHelper.scanImage(device);
                System.out.println("scanned image info: size=(" + ((BufferedImage)object).getWidth() + ", " + ((BufferedImage)object).getHeight() + ")   bit mode=" + ((BufferedImage)object).getColorModel().getPixelSize());
                Thread.sleep(30000L);
            }
        } else {
            System.out.println("No device connected!!!");
        }
    }

    private void batchScan() throws Exception {
        List<Device> list = manager.listDevices();
        ArrayList<File> arrayList = new ArrayList<File>();
        if (list.size() > 0) {
            Device device = list.get(0);
            if (device != null && device instanceof Scanner) {
                Scanner scanner = (Scanner)device;
                scanner.setMode(8);
                scanner.setResolution(200);
                int n = scanner.getFeederFunctionalUnit();
                System.out.println("Feeder unit : " + (n >= 0 ? Integer.valueOf(n) : "none found - trying 0"));
                if (n < 0) {
                    n = 0;
                }
                if (scanner.isDuplexSupported()) {
                    scanner.setDuplexEnabled(true);
                }
                int n2 = 1;
                ScanSession scanSession = new ScanSession();
                try {
                    scanSession.startSession(device, n);
                    File file = null;
                    while (null != (file = scanSession.getImageFile())) {
                        arrayList.add(file);
                        BufferedImage bufferedImage = ImageIO.read(file);
                        System.out.println("scanned image " + file.getPath() + " : size=(" + bufferedImage.getWidth() + ", " + bufferedImage.getHeight() + ")   bit mode=" + bufferedImage.getColorModel().getPixelSize());
                        if ("jpg".equalsIgnoreCase(ScanSession.getExt(file))) continue;
                        File file2 = new File(file.getParent(), "Morena_example_img_" + n2++ + ".jpg");
                        FileOutputStream fileOutputStream = new FileOutputStream(file2);
                        ImageIO.write((RenderedImage)bufferedImage, "jpeg", fileOutputStream);
                        fileOutputStream.close();
                        arrayList.add(file2);
                    }
                }
                catch (Exception exception) {
                    if (scanSession.isEmptyFeeder()) {
                        System.out.println("No more sheets in the document feeder");
                    }
                    exception.printStackTrace();
                }
            }
            System.out.println("Scanning completed - check the images ... waiting 120s");
            Thread.sleep(120000L);
            for (File file : arrayList) {
                file.deleteOnExit();
            }
        } else {
            System.out.println("No device connected!!!");
        }
    }
}

