/*
 * Decompiled with CFR 0.152.
 */
import eu.gnome.morena.Configuration;
import eu.gnome.morena.Device;
import eu.gnome.morena.DeviceListChangeListener;
import eu.gnome.morena.Manager;
import eu.gnome.morena.Scanner;
import eu.gnome.morena.TransferListener;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Graphics;
import java.awt.GridLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.HttpURLConnection;
import java.net.URL;
import java.util.Date;
import javax.imageio.ImageIO;
import javax.swing.AbstractAction;
import javax.swing.JApplet;
import javax.swing.JFileChooser;
import javax.swing.JFrame;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.JToolBar;
import javax.swing.border.LineBorder;
import javax.swing.filechooser.FileFilter;

public class MorenaStudio
extends JApplet {
    private static Manager manager;

    public void init() {
        manager = Manager.getInstance();
        new MainPanel(this.getContentPane(), this.getDocumentBase());
    }

    public void start() {
        System.err.println("Morena is available " + manager.available());
    }

    public void stop() {
        manager.close();
    }

    public static void main(String[] stringArray) {
        boolean bl = false;
        if (stringArray != null && stringArray.length > 0 && stringArray.length >= 1) {
            bl = Boolean.parseBoolean(stringArray[0]);
        }
        System.err.println("Configuration: native UI - " + bl);
        JFrame jFrame = new JFrame("Morena Studio");
        if (bl) {
            Configuration.setMode(1);
        }
        manager = Manager.getInstance();
        jFrame.setDefaultCloseOperation(3);
        jFrame.addWindowListener(new WindowAdapter(){

            public void windowClosing(WindowEvent windowEvent) {
                manager.close();
            }
        });
        new MainPanel(jFrame.getContentPane(), null);
        jFrame.setBounds(100, 100, 600, 400);
        jFrame.setVisible(true);
    }

    static {
        System.err.println("MorenaStudio started at " + new Date());
    }

    private static class MainPanel
    extends JPanel
    implements DeviceListChangeListener {
        private JTextField status = new JTextField();
        private ImagePanel selected = null;
        private SaveImageAction saveImageAction;
        private CancelAction cancelAction;
        private UploadImageAction uploadImageAction;
        private MouseListener mouseListener = new MouseListener();
        private boolean hasServer = false;
        private URL documentBase = null;
        private Scanner scanner = null;

        void select(ImagePanel imagePanel) {
            if (this.selected != null) {
                this.selected.setBorder(null);
            }
            this.selected = imagePanel;
            if (this.selected != null) {
                this.selected.setBorder(new LineBorder(Color.blue, 1));
                this.saveImageAction.setEnabled(true);
                this.uploadImageAction.setEnabled(this.hasServer);
            } else {
                this.saveImageAction.setEnabled(false);
                this.uploadImageAction.setEnabled(false);
            }
        }

        public void listChanged() {
        }

        public void deviceConnected(Device device) {
            this.status.setText("device connected : " + device);
        }

        public void deviceDisconnected(Device device) {
            this.status.setText("device disconnected : " + device);
        }

        MainPanel(Container container, URL uRL) {
            this.documentBase = uRL;
            this.status.setEditable(false);
            this.hasServer = uRL != null && uRL.getProtocol().indexOf("http") != -1;
            container.add((Component)new ToolBar(), "North");
            container.add((Component)this, "Center");
            container.add((Component)this.status, "South");
            this.setLayout(new GridLayout(1, 1));
            manager.addDeviceListChangeListener(this);
        }

        private class ToolBar
        extends JToolBar {
            ToolBar() {
                this.addSeparator();
                this.add(new AcquireImageAction());
                this.addSeparator();
                this.add(MainPanel.this.cancelAction = new CancelAction());
                this.addSeparator();
                this.add(MainPanel.this.saveImageAction = new SaveImageAction());
                MainPanel.this.saveImageAction.setEnabled(false);
                this.addSeparator();
                this.add(MainPanel.this.uploadImageAction = new UploadImageAction());
                MainPanel.this.uploadImageAction.setEnabled(false);
                this.addSeparator();
                this.add(new RemoveAllAction());
                this.setMargin(new Insets(4, 2, 2, 2));
            }
        }

        private class ImagePanel
        extends JPanel {
            private BufferedImage image;
            int imageWidth;
            int imageHeight;

            ImagePanel(BufferedImage bufferedImage) {
                this.image = bufferedImage;
                this.imageWidth = bufferedImage.getWidth();
                this.imageHeight = bufferedImage.getHeight();
                this.addMouseListener(MainPanel.this.mouseListener);
            }

            public BufferedImage getImage() {
                return this.image;
            }

            public void paint(Graphics graphics) {
                super.paint(graphics);
                int n = this.getWidth() - 6;
                int n2 = this.getHeight() - 6;
                double d = (double)n / (double)this.imageWidth;
                double d2 = (double)n2 / (double)this.imageHeight;
                if (d > d2) {
                    graphics.drawImage(this.image, (int)((double)n - (double)this.imageWidth * d2) / 2 + 3, 3, (int)((double)this.imageWidth * d2), (int)((double)this.imageHeight * d2), this);
                } else {
                    graphics.drawImage(this.image, 3, 3, (int)((double)this.imageWidth * d), (int)((double)this.imageHeight * d), this);
                }
            }
        }

        private class MouseListener
        extends MouseAdapter {
            private MouseListener() {
            }

            public void mouseClicked(MouseEvent mouseEvent) {
                MainPanel.this.select((ImagePanel)mouseEvent.getComponent());
            }
        }

        private class UploadImageAction
        extends AbstractAction
        implements Runnable {
            UploadImageAction() {
                super("upload to server");
            }

            public void actionPerformed(ActionEvent actionEvent) {
                new Thread(this).start();
            }

            public synchronized void run() {
                try {
                    int n;
                    MainPanel.this.status.setText("Working ...");
                    BufferedImage bufferedImage = MainPanel.this.selected.getImage();
                    ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
                    ImageIO.write((RenderedImage)bufferedImage, "jpg", byteArrayOutputStream);
                    byteArrayOutputStream.close();
                    int n2 = byteArrayOutputStream.size();
                    if (n2 > 0x100000) {
                        throw new Exception("Image is too big to upload");
                    }
                    URL uRL = new URL(MainPanel.this.documentBase, "upload.php");
                    HttpURLConnection httpURLConnection = (HttpURLConnection)uRL.openConnection();
                    httpURLConnection.setRequestMethod("POST");
                    httpURLConnection.setDoOutput(true);
                    httpURLConnection.setUseCaches(false);
                    httpURLConnection.setDefaultUseCaches(false);
                    httpURLConnection.setRequestProperty("content-type", "img/jpeg");
                    httpURLConnection.setRequestProperty("content-length", String.valueOf(n2));
                    OutputStream outputStream = httpURLConnection.getOutputStream();
                    outputStream.write(byteArrayOutputStream.toByteArray());
                    outputStream.close();
                    InputStream inputStream = httpURLConnection.getInputStream();
                    while ((n = inputStream.read()) != -1) {
                        System.err.write(n);
                    }
                    inputStream.close();
                    URL uRL2 = new URL(MainPanel.this.documentBase, httpURLConnection.getHeaderField("file-name"));
                    MainPanel.this.status.setText("Done - image is uploaded to " + uRL2 + " (for at least 5 minutes) ...");
                }
                catch (Throwable throwable) {
                    JOptionPane.showMessageDialog(MainPanel.this, throwable.toString(), "Error", 0);
                    throwable.printStackTrace();
                    MainPanel.this.status.setText("Failed, try again ...");
                }
            }

            public boolean isEnabled() {
                return MainPanel.this.hasServer && MainPanel.this.selected != null;
            }
        }

        private class SaveImageAction
        extends AbstractAction
        implements Runnable {
            SaveImageAction() {
                super("save to file");
            }

            public void actionPerformed(ActionEvent actionEvent) {
                new Thread(this).start();
            }

            public synchronized void run() {
                try {
                    int n;
                    MainPanel.this.status.setText("Working ...");
                    BufferedImage bufferedImage = MainPanel.this.selected.getImage();
                    JFileChooser jFileChooser = new JFileChooser();
                    String[] stringArray = ImageIO.getWriterFormatNames();
                    for (n = 0; n < stringArray.length; ++n) {
                        jFileChooser.addChoosableFileFilter(new Filter(stringArray[n]));
                    }
                    n = jFileChooser.showSaveDialog(MainPanel.this);
                    if (n == 0) {
                        String string = jFileChooser.getFileFilter().getDescription();
                        string = string.substring(0, string.indexOf(32)).toLowerCase();
                        File file = jFileChooser.getSelectedFile();
                        String string2 = file.getName();
                        if (!string2.endsWith(string)) {
                            file = new File(file.getParentFile(), string2 + "." + string);
                        }
                        ImageIO.write((RenderedImage)bufferedImage, string, file);
                        MainPanel.this.status.setText("Done - image is saved to " + file + "  ...");
                    } else {
                        MainPanel.this.status.setText("Canceled  ...");
                    }
                }
                catch (Throwable throwable) {
                    JOptionPane.showMessageDialog(MainPanel.this, throwable.toString(), "Error", 0);
                    throwable.printStackTrace();
                    MainPanel.this.status.setText("Failed, try again ...");
                }
            }

            public boolean isEnabled() {
                return MainPanel.this.selected != null;
            }

            private class Filter
            extends FileFilter {
                String type;

                Filter(String string) {
                    this.type = string;
                }

                public boolean accept(File file) {
                    return file.getName().endsWith(this.type);
                }

                public String getDescription() {
                    return this.type + " Files";
                }
            }
        }

        private class CancelAction
        extends AbstractAction {
            CancelAction() {
                super("cancel");
                this.setEnabled(false);
            }

            public synchronized void actionPerformed(ActionEvent actionEvent) {
                MainPanel.this.scanner.cancelTransfer();
            }
        }

        private class AcquireImageAction
        extends AbstractAction
        implements TransferListener {
            AcquireImageAction() {
                super("acquire image");
            }

            public synchronized void actionPerformed(ActionEvent actionEvent) {
                try {
                    MainPanel.this.status.setText("Working ...");
                    Device device = manager.selectDevice(MainPanel.this);
                    if (device != null) {
                        if (device instanceof Scanner) {
                            MainPanel.this.scanner = (Scanner)device;
                            if (MainPanel.this.scanner.setupDevice(MainPanel.this)) {
                                this.setEnabled(false);
                                MainPanel.this.cancelAction.setEnabled(true);
                                MainPanel.this.scanner.startTransfer(this);
                            }
                        } else {
                            MainPanel.this.scanner = null;
                            device.startTransfer(this);
                        }
                        MainPanel.this.status.setText("Selected " + device + "  ...");
                    } else {
                        MainPanel.this.status.setText("Failed, try again ...");
                    }
                }
                catch (Throwable throwable) {
                    JOptionPane.showMessageDialog(MainPanel.this, throwable.toString(), "Error", 0);
                    throwable.printStackTrace();
                    MainPanel.this.status.setText("Failed, try again ...");
                    this.setEnabled(true);
                    MainPanel.this.cancelAction.setEnabled(false);
                }
            }

            public void transferDone(File file) {
                try {
                    BufferedImage bufferedImage = ImageIO.read(file);
                    if (bufferedImage != null) {
                        ImagePanel imagePanel = new ImagePanel(bufferedImage);
                        MainPanel.this.add(imagePanel);
                        MainPanel.this.select(imagePanel);
                        int n = (int)Math.round(Math.sqrt(MainPanel.this.getComponentCount()));
                        MainPanel.this.setLayout(new GridLayout(n, n));
                        MainPanel.this.status.setText("Done [" + file.getAbsolutePath() + "]...");
                        MainPanel.this.validate();
                    } else {
                        MainPanel.this.status.setText("Done [" + file.getAbsolutePath() + "] - can not display this image type");
                    }
                }
                catch (Exception exception) {
                    exception.printStackTrace();
                }
                this.setEnabled(true);
                MainPanel.this.cancelAction.setEnabled(false);
            }

            public void transferFailed(int n, String string) {
                MainPanel.this.status.setText(string + " [0x" + Integer.toHexString(n) + "]");
                this.setEnabled(true);
                MainPanel.this.cancelAction.setEnabled(false);
            }

            public void transferProgress(int n) {
                MainPanel.this.status.setText(n + "%");
            }
        }

        private class RemoveAllAction
        extends AbstractAction
        implements Runnable {
            RemoveAllAction() {
                super("remove all");
            }

            public synchronized void actionPerformed(ActionEvent actionEvent) {
                new Thread(this).start();
            }

            public synchronized void run() {
                MainPanel.this.removeAll();
                MainPanel.this.select(null);
                MainPanel.this.repaint();
            }
        }
    }
}

