/*
 * Decompiled with CFR 0.152.
 */
package tmrechnungstool.dto;

import java.math.BigDecimal;
import java.util.logging.Level;
import java.util.logging.Logger;
import tmrechnungstool.c;

public class TmBetrag {
    private long euro = 0L;
    private int cent = 0;
    private int zeichen = 1;
    private static final int MAX_LONG = 18;

    public TmBetrag(long l2, int n2) {
        this.euro = l2;
        this.cent = n2;
    }

    public TmBetrag(long l2) {
        this.euro = l2;
    }

    public TmBetrag() {
    }

    public long toCent() {
        TmBetrag.checkMaxLength("" + this.euro, 16);
        return (long)this.zeichen * (100L * this.euro) + (long)(this.zeichen * this.cent);
    }

    public TmBetrag clone() {
        TmBetrag tmBetrag = new TmBetrag();
        tmBetrag.setEuro(this.euro);
        tmBetrag.setCent(this.cent);
        tmBetrag.setZeichen(this.zeichen);
        return tmBetrag;
    }

    public TmBetrag dividieren(TmBetrag tmBetrag) {
        long l2 = tmBetrag.toCent();
        TmBetrag.checkMaxLength(this.getEuro(), 16);
        return this.multiplizieren(100L).dividieren(l2);
    }

    public TmBetrag dividieren(long l2) {
        if (l2 == 0L) {
            throw new Exception("0 dividieren");
        }
        TmBetrag tmBetrag = new TmBetrag();
        tmBetrag.setZeichen(this.zeichen);
        if (l2 < 0L) {
            tmBetrag.setZeichen(-1 * this.zeichen);
            l2 = -1L * l2;
        }
        TmBetrag.checkMaxLength(this.euro, 16);
        double d2 = (long)this.cent + 100L * this.euro;
        double d3 = d2 / (double)l2;
        long l3 = (long)(d3 + 0.5);
        TmBetrag tmBetrag2 = TmBetrag.CentStringToTmBetrag(l3);
        tmBetrag.setEuro(tmBetrag2.getEuro());
        tmBetrag.setCent(tmBetrag2.getCent());
        return tmBetrag;
    }

    public TmBetrag multiplizieren(long l2) {
        TmBetrag tmBetrag = new TmBetrag();
        tmBetrag.setZeichen(this.zeichen);
        if (l2 < 0L) {
            tmBetrag.setZeichen(-1 * tmBetrag.getZeichen());
            l2 = -1L * l2;
        }
        long l3 = this.toCent();
        String string = "" + l3 + l2;
        TmBetrag.checkMaxLength(string, 18);
        long l4 = l3 * l2;
        TmBetrag tmBetrag2 = TmBetrag.CentStringToTmBetrag(l4);
        tmBetrag.setEuro(tmBetrag2.getEuro());
        tmBetrag.setCent(tmBetrag2.getCent());
        return tmBetrag;
    }

    public TmBetrag multiplizieren(TmBetrag object) {
        TmBetrag tmBetrag = new TmBetrag();
        tmBetrag.setZeichen(this.zeichen * ((TmBetrag)object).getZeichen());
        long l2 = this.toCent();
        long l3 = ((TmBetrag)object).toCent();
        l2 = Math.abs(l2);
        l3 = Math.abs(l3);
        object = "" + l2 + l3;
        TmBetrag.checkMaxLength((String)object, 18);
        long l4 = l2 * l3;
        long l5 = l4 / 10000L;
        long l6 = l4 - l5 * 10000L;
        int n2 = (int)((double)(l6 / 100L) + 0.5);
        if (n2 == 100) {
            ++l5;
            n2 = 0;
        }
        tmBetrag.setEuro(l5);
        tmBetrag.setCent(n2);
        return tmBetrag;
    }

    public static TmBetrag CentStringToTmBetragOhneException(String string) {
        try {
            TmBetrag.checkMaxLength(string, 18);
            long l2 = Long.parseLong(string);
            return TmBetrag.CentStringToTmBetrag(l2);
        }
        catch (Exception exception) {
            return new TmBetrag();
        }
    }

    public static TmBetrag CentToTmBetrag(String string) {
        TmBetrag.checkMaxLength(string, 18);
        long l2 = Long.parseLong(string);
        return TmBetrag.CentStringToTmBetrag(l2);
    }

    public static TmBetrag CentStringToTmBetrag(long l2) {
        TmBetrag.checkMaxLength(l2, 18);
        TmBetrag tmBetrag = new TmBetrag();
        if (l2 < 0L) {
            tmBetrag.setZeichen(-1);
            l2 = -1L * l2;
        }
        if (l2 < 100L) {
            tmBetrag.setCent((int)l2);
            return tmBetrag;
        }
        String string = "" + l2;
        if ((string = string.substring(string.length() - 2)).substring(0, 1).equals("0")) {
            string = string.substring(1);
        }
        int n2 = Integer.parseInt(string);
        tmBetrag.setCent(n2);
        tmBetrag.setEuro((l2 - (long)n2) / 100L);
        return tmBetrag;
    }

    public TmBetrag plus(TmBetrag tmBetrag) {
        TmBetrag tmBetrag2 = new TmBetrag();
        long l2 = this.toCent();
        long l3 = tmBetrag.toCent();
        TmBetrag.checkMaxLength(l2, 17);
        TmBetrag.checkMaxLength(l3, 17);
        long l4 = l2 + l3;
        int n2 = 1;
        if (l4 < 0L) {
            n2 = -1;
        }
        l4 = Math.abs(l4);
        long l5 = l4 / 100L;
        tmBetrag2.setEuro(l5);
        tmBetrag2.setCent((int)(l4 -= l5 * 100L));
        tmBetrag2.setZeichen(n2);
        return tmBetrag2;
    }

    public TmBetrag minus(TmBetrag tmBetrag) {
        tmBetrag = tmBetrag.clone();
        tmBetrag.setZeichen(-tmBetrag.getZeichen());
        return this.plus(tmBetrag);
    }

    public static TmBetrag parseDbToTmbetrag_OhneException(String string) {
        try {
            return TmBetrag.getDbToTmbetrag(string);
        }
        catch (Exception exception) {
            return new TmBetrag();
        }
    }

    public static TmBetrag parseGuiToTmbetrag_OhneException(c c2, String string) {
        try {
            return TmBetrag.getGuiToTmbetrag(c2, string);
        }
        catch (Exception exception) {
            return new TmBetrag();
        }
    }

    public boolean istZero() {
        return this.euro == 0L && this.cent == 0;
    }

    public boolean istGleich(TmBetrag tmBetrag) {
        return this.euro == tmBetrag.getEuro() && this.cent == tmBetrag.getCent() && this.zeichen == tmBetrag.getZeichen();
    }

    public boolean istGroesse(TmBetrag tmBetrag) {
        if (this.euro * (long)this.zeichen > tmBetrag.getEuro() * (long)tmBetrag.getZeichen()) {
            return true;
        }
        if (this.euro * (long)this.zeichen < tmBetrag.getEuro() * (long)tmBetrag.getZeichen()) {
            return false;
        }
        return this.cent * this.zeichen > tmBetrag.getCent() * tmBetrag.getZeichen();
    }

    public boolean istKleiner(TmBetrag tmBetrag) {
        if (this.euro * (long)this.zeichen < tmBetrag.getEuro() * (long)tmBetrag.getZeichen()) {
            return true;
        }
        if (this.euro * (long)this.zeichen > tmBetrag.getEuro() * (long)tmBetrag.getZeichen()) {
            return false;
        }
        return this.cent * this.zeichen < tmBetrag.getCent() * tmBetrag.getZeichen();
    }

    public int getCent() {
        return this.cent;
    }

    public String getCent2Stellig() {
        String string = this.cent < 10 ? "0" + this.cent : "" + this.cent;
        return string;
    }

    public void setCent(int n2) {
        this.cent = n2;
    }

    public long getEuro() {
        return this.euro;
    }

    public void setEuro(long l2) {
        this.euro = l2;
    }

    public void setEuro(int n2) {
        this.euro = n2;
    }

    public int getZeichen() {
        return this.zeichen;
    }

    public void setZeichen(int n2) {
        this.zeichen = n2;
    }

    private static void checkMaxLength(String string, int n2) {
        if (string.length() > n2) {
            throw new Exception("Der Betrag ist gro\u00df. Bitte wenden Sie sich an den Softwarehersteller. [" + string + "][" + n2 + "]");
        }
    }

    private static void checkMaxLength(long l2, int n2) {
        TmBetrag.checkMaxLength("" + l2, n2);
    }

    public void runden5Cent() {
        int n2 = this.getCent();
        n2 = (int)Math.round((double)n2 / 5.0);
        if ((n2 *= 5) == 100) {
            this.setEuro(this.getEuro() + 1L);
            this.setCent(0);
            return;
        }
        this.setCent(n2);
    }

    public double toDouble() {
        String string = this.getEuro() + "." + this.getCent2Stellig();
        if (this.getZeichen() < 0) {
            string = "-" + string;
        }
        double d2 = Double.parseDouble(string);
        return d2;
    }

    public BigDecimal toBigDecimal() {
        Object object = this.getEuro() + "." + this.getCent2Stellig();
        if (this.getZeichen() < 0) {
            object = "-" + (String)object;
        }
        object = new BigDecimal((String)object);
        return object;
    }

    public static int compare(TmBetrag tmBetrag, TmBetrag tmBetrag2) {
        if (tmBetrag.istGroesse(tmBetrag2)) {
            return 1;
        }
        if (tmBetrag2.istGroesse(tmBetrag)) {
            return -1;
        }
        return 0;
    }

    public static TmBetrag getNetto(TmBetrag tmBetrag, TmBetrag tmBetrag2) {
        TmBetrag tmBetrag3 = new TmBetrag();
        try {
            tmBetrag = tmBetrag.plus(new TmBetrag(100L));
            tmBetrag3 = tmBetrag2.multiplizieren(100L).dividieren(tmBetrag);
        }
        catch (Exception exception) {}
        return tmBetrag3;
    }

    public static TmBetrag getBrutto(TmBetrag tmBetrag, TmBetrag tmBetrag2) {
        TmBetrag tmBetrag3 = new TmBetrag();
        try {
            tmBetrag = tmBetrag2.multiplizieren(tmBetrag).dividieren(100L);
            tmBetrag3 = tmBetrag2.plus(tmBetrag);
        }
        catch (Exception exception) {}
        return tmBetrag3;
    }

    public static TmBetrag getUst(TmBetrag tmBetrag, TmBetrag tmBetrag2) {
        TmBetrag tmBetrag3 = new TmBetrag();
        try {
            tmBetrag3 = tmBetrag2.minus(tmBetrag);
        }
        catch (Exception exception) {
            Logger.getLogger(TmBetrag.class.getName()).log(Level.SEVERE, null, exception);
        }
        return tmBetrag3;
    }

    public static TmBetrag getDbToTmbetrag(String string) {
        string = string.replace(".", "");
        TmBetrag tmBetrag = new TmBetrag();
        if ((string = string.trim()).substring(0, 1).equals("-")) {
            string = string.substring(1);
            tmBetrag.setZeichen(-1);
        } else {
            tmBetrag.setZeichen(1);
        }
        if (string.equals("-")) {
            throw new Exception("Der Betrag konnte nicht geparst werden: " + string);
        }
        int n2 = string.indexOf(".");
        int n3 = string.indexOf(",");
        if (n2 > 0 && n3 > 0) {
            throw new Exception("Der Betrag konnte nicht geparst werden: " + string);
        }
        long l2 = 0L;
        int n4 = 0;
        String[] stringArray = null;
        if (n2 > 0) {
            stringArray = string.split(".");
        } else if (n3 > 0) {
            stringArray = string.split(",");
        } else {
            TmBetrag.checkMaxLength(string, 18);
            l2 = Long.parseLong(string);
            n4 = 0;
        }
        if (n2 > 0 || n3 > 0) {
            if (stringArray.length != 2) {
                throw new Exception("Der Betrag konnte nicht geparst werden: " + string);
            }
            TmBetrag.checkMaxLength(stringArray[0], 18);
            l2 = Long.parseLong(stringArray[0]);
            if (stringArray[1].length() > 2) {
                throw new Exception("Der Betrag konnte nicht geparst werden: " + string);
            }
            n4 = Integer.parseInt(stringArray[1]);
            if (n4 < 10 && stringArray[1].length() == 1) {
                n4 *= 10;
            }
        }
        tmBetrag.setEuro(l2);
        tmBetrag.setCent(n4);
        return tmBetrag;
    }

    public String getTmbetragToDb() {
        return this.toString();
    }

    public String toString() {
        String string = "";
        if (this.zeichen < 0) {
            string = "-";
        }
        String string2 = "" + this.euro;
        String string3 = "";
        while (string2.length() > 3) {
            String string4 = string2.substring(string2.length() - 3);
            string2 = string2.substring(0, string2.length() - 3);
            if (string3.isEmpty()) {
                string3 = string4;
                continue;
            }
            string3 = string4 + "." + string3;
        }
        string3 = string3.isEmpty() ? string2 : string2 + "." + string3;
        string = this.cent < 10 ? string + string3 + ",0" + this.cent : string + string3 + "," + this.cent;
        return string;
    }

    public static TmBetrag getGuiToTmbetrag(c object, String string) {
        String string2 = ((c)object).p().getTmbetragTsnd();
        object = ((c)object).p().getTmbetragCent();
        string = string.replace(string2, "");
        TmBetrag tmBetrag = new TmBetrag();
        if ((string = string.trim()).substring(0, 1).equals("-")) {
            string = string.substring(1);
            tmBetrag.setZeichen(-1);
        } else {
            tmBetrag.setZeichen(1);
        }
        if (string.equals("-")) {
            throw new Exception("Der Betrag konnte nicht geparst werden: " + string);
        }
        int n2 = string.indexOf(string2);
        int n3 = string.indexOf((String)object);
        if (n2 > 0 && n3 > 0) {
            throw new Exception("Der Betrag konnte nicht geparst werden: " + string);
        }
        long l2 = 0L;
        int n4 = 0;
        String[] stringArray = null;
        if (n2 > 0) {
            stringArray = string2.equals(".") ? string.split("\\.") : string.split(string2);
        } else if (n3 > 0) {
            stringArray = ((String)object).equals(".") ? string.split("\\.") : string.split((String)object);
        } else {
            TmBetrag.checkMaxLength(string, 18);
            l2 = Long.parseLong(string);
            n4 = 0;
        }
        if (n2 > 0 || n3 > 0) {
            if (stringArray.length != 2) {
                throw new Exception("Der Betrag konnte nicht geparst werden: " + string);
            }
            TmBetrag.checkMaxLength(stringArray[0], 18);
            l2 = Long.parseLong(stringArray[0]);
            if (stringArray[1].length() > 2) {
                throw new Exception("Der Betrag konnte nicht geparst werden: " + string);
            }
            n4 = Integer.parseInt(stringArray[1]);
            if (n4 < 10 && stringArray[1].length() == 1) {
                n4 *= 10;
            }
        }
        tmBetrag.setEuro(l2);
        tmBetrag.setCent(n4);
        return tmBetrag;
    }

    public String getTmbetragToGui(c object) {
        String string = ((c)object).p().getTmbetragTsnd();
        object = ((c)object).p().getTmbetragCent();
        String string2 = "";
        if (this.zeichen < 0) {
            string2 = "-";
        }
        String string3 = "" + this.euro;
        String string4 = "";
        while (string3.length() > 3) {
            String string5 = string3.substring(string3.length() - 3);
            string3 = string3.substring(0, string3.length() - 3);
            if (string4.isEmpty()) {
                string4 = string5;
                continue;
            }
            string4 = string5 + string + string4;
        }
        string4 = string4.isEmpty() ? string3 : string3 + string + string4;
        string2 = this.cent < 10 ? string2 + string4 + (String)object + "0" + this.cent : string2 + string4 + (String)object + this.cent;
        return string2;
    }

    public static String dbToGui(c c2, String object) {
        if (((String)object).isEmpty()) {
            return "";
        }
        object = TmBetrag.parseDbToTmbetrag_OhneException((String)object);
        return ((TmBetrag)object).getTmbetragToGui(c2);
    }

    public static String guiToDb(c object, String string) {
        if (string.isEmpty()) {
            return "";
        }
        object = TmBetrag.parseGuiToTmbetrag_OhneException((c)object, string);
        return ((TmBetrag)object).getTmbetragToDb();
    }

    public static TmBetrag parseDouble(double d2) {
        Object object = new Double(d2);
        long l2 = ((Double)object).longValue();
        long l3 = l2 * 100L;
        object = (Double)object * 100.0;
        long l4 = ((Double)object).longValue();
        long l5 = l4 - l3;
        object = new TmBetrag(l2, (int)l5);
        return object;
    }

    public long aufrunden() {
        if (this.getCent() == 0) {
            return (long)this.getZeichen() * this.getEuro();
        }
        if (this.getZeichen() > 0) {
            return this.getEuro() + 1L;
        }
        return -1L * this.getEuro();
    }

    public long abrunden() {
        if (this.getCent() == 0) {
            return (long)this.getZeichen() * this.getEuro();
        }
        if (this.getZeichen() > 0) {
            return this.getEuro();
        }
        return -1L * this.getEuro() - 1L;
    }

    public TmBetrag multiplizieren(double d2) {
        double d3 = this.toDouble() * d2;
        TmBetrag tmBetrag = TmBetrag.parseDouble(d3);
        return tmBetrag;
    }
}

